/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.process.traversal.util.ImmutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;

public class MutableMetrics
extends ImmutableMetrics
implements Cloneable {
    private long tempTime = -1L;
    private volatile boolean finalized = false;

    protected MutableMetrics() {
    }

    public MutableMetrics(String id, String name2) {
        this.id = id;
        this.name = name2;
    }

    public MutableMetrics(Metrics other) {
        this.id = other.getId();
        this.name = other.getName();
        this.annotations.putAll(other.getAnnotations());
        this.durationNs = other.getDuration(TimeUnit.NANOSECONDS);
        other.getCounts().forEach((key, count2) -> this.counts.put(key, new AtomicLong((long)count2)));
        other.getNested().forEach(nested2 -> this.addNested(new MutableMetrics((Metrics)nested2)));
    }

    public synchronized void addNested(MutableMetrics metrics) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        this.nested.put(metrics.getId(), metrics);
    }

    public void start() {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        if (-1L != this.tempTime) {
            throw new IllegalStateException("Internal Error: Concurrent Metrics start. Stop timer before starting timer.");
        }
        this.tempTime = System.nanoTime();
    }

    public void stop() {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        if (-1L == this.tempTime) {
            throw new IllegalStateException("Internal Error: Metrics has not been started. Start timer before stopping timer");
        }
        this.durationNs += System.nanoTime() - this.tempTime;
        this.tempTime = -1L;
    }

    public synchronized void incrementCount(String key, long incr) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        AtomicLong count2 = (AtomicLong)this.counts.get(key);
        if (count2 == null) {
            count2 = new AtomicLong();
            this.counts.put(key, count2);
        }
        count2.addAndGet(incr);
    }

    public void setDuration(long dur, TimeUnit unit) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        this.durationNs = TimeUnit.NANOSECONDS.convert(dur, unit);
    }

    public void setCount(String key, long val) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        this.counts.put(key, new AtomicLong(val));
    }

    public synchronized void aggregate(MutableMetrics other) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        this.durationNs += other.durationNs;
        for (Map.Entry otherCount : other.counts.entrySet()) {
            AtomicLong thisCount = (AtomicLong)this.counts.get(otherCount.getKey());
            if (thisCount == null) {
                thisCount = new AtomicLong(((AtomicLong)otherCount.getValue()).get());
                this.counts.put(otherCount.getKey(), thisCount);
                continue;
            }
            thisCount.addAndGet(((AtomicLong)otherCount.getValue()).get());
        }
        for (Map.Entry p : other.annotations.entrySet()) {
            if (this.annotations.containsKey(p.getKey())) {
                Object existingVal = this.annotations.get(p.getKey());
                if (existingVal instanceof String) {
                    List<String> existingValues = Arrays.asList(existingVal.toString().split(","));
                    if (existingValues.contains(p.getValue())) continue;
                    this.annotations.put(p.getKey(), existingVal.toString() + ',' + p.getValue());
                    continue;
                }
                Number existingNum = (Number)existingVal;
                Number otherNum = (Number)p.getValue();
                Number newVal = existingNum instanceof Double || existingNum instanceof Float ? (Number)(existingNum.doubleValue() + otherNum.doubleValue()) : (Number)(existingNum.longValue() + otherNum.longValue());
                this.annotations.put(p.getKey(), newVal);
                continue;
            }
            this.annotations.put(p.getKey(), p.getValue());
        }
        this.annotations.putAll(other.annotations);
        other.nested.values().forEach(nested2 -> {
            MutableMetrics thisNested = (MutableMetrics)this.nested.get(nested2.getId());
            if (thisNested == null) {
                thisNested = new MutableMetrics(nested2.getId(), nested2.getName());
                this.nested.put(thisNested.getId(), thisNested);
            }
            thisNested.aggregate((MutableMetrics)nested2);
        });
    }

    public void setAnnotation(String key, Object value2) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        if (!(value2 instanceof String) && !(value2 instanceof Number)) {
            throw new IllegalArgumentException("Metrics annotations only support String and Number values.");
        }
        this.annotations.put(key, value2);
    }

    @Override
    public MutableMetrics getNested(String metricsId) {
        return (MutableMetrics)this.nested.get(metricsId);
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public synchronized ImmutableMetrics getImmutableClone() {
        this.finalized = true;
        ImmutableMetrics clone2 = new ImmutableMetrics();
        this.copyMembers(clone2);
        this.nested.values().forEach(nested2 -> clone2.nested.put(nested2.id, ((MutableMetrics)nested2).getImmutableClone()));
        return clone2;
    }

    protected void copyMembers(ImmutableMetrics clone2) {
        clone2.id = this.id;
        clone2.name = this.name;
        clone2.durationNs = this.durationNs;
        for (Map.Entry c : this.counts.entrySet()) {
            clone2.counts.put((String)c.getKey(), new AtomicLong(((AtomicLong)c.getValue()).get()));
        }
        for (Map.Entry a : this.annotations.entrySet()) {
            clone2.annotations.put((String)a.getKey(), a.getValue());
        }
    }

    public MutableMetrics clone() {
        MutableMetrics clone2 = new MutableMetrics();
        this.copyMembers(clone2);
        this.nested.values().forEach(nested2 -> {
            ImmutableMetrics cfr_ignored_0 = clone2.nested.put(nested2.id, ((MutableMetrics)nested2).clone());
        });
        return clone2;
    }

    public void finish(long bulk) {
        this.stop();
        this.incrementCount("traverserCount", 1L);
        this.incrementCount("elementCount", bulk);
    }
}

