/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class DefaultTraversalStrategies
implements TraversalStrategies {
    protected Set<TraversalStrategy<?>> traversalStrategies = new LinkedHashSet();

    @Override
    public TraversalStrategies addStrategies(TraversalStrategy<?> ... strategies) {
        for (TraversalStrategy<?> addStrategy : strategies) {
            this.traversalStrategies.remove(addStrategy);
        }
        Collections.addAll(this.traversalStrategies, strategies);
        this.traversalStrategies = TraversalStrategies.sortStrategies(this.traversalStrategies);
        return this;
    }

    @Override
    public TraversalStrategies removeStrategies(Class<? extends TraversalStrategy> ... strategyClasses) {
        boolean removed = false;
        for (Class<? extends TraversalStrategy> strategyClass : strategyClasses) {
            Optional<TraversalStrategy> strategy = this.traversalStrategies.stream().filter(s2 -> s2.getClass().equals(strategyClass)).findAny();
            if (!strategy.isPresent()) continue;
            this.traversalStrategies.remove(strategy.get());
            removed = true;
        }
        if (removed) {
            this.traversalStrategies = TraversalStrategies.sortStrategies(this.traversalStrategies);
        }
        return this;
    }

    @Override
    public List<TraversalStrategy<?>> toList() {
        return Collections.unmodifiableList(new ArrayList(this.traversalStrategies));
    }

    @Override
    public <T extends TraversalStrategy> Optional<T> getStrategy(Class<T> traversalStrategyClass) {
        for (TraversalStrategy<?> traversalStrategy : this.traversalStrategies) {
            if (!traversalStrategyClass.isAssignableFrom(traversalStrategy.getClass())) continue;
            return Optional.of(traversalStrategy);
        }
        return Optional.empty();
    }

    @Override
    @Deprecated
    public void applyStrategies(Traversal.Admin<?, ?> traversal) {
        for (TraversalStrategy<?> traversalStrategy : this.traversalStrategies) {
            traversalStrategy.apply(traversal);
        }
    }

    @Override
    public DefaultTraversalStrategies clone() {
        try {
            DefaultTraversalStrategies clone2 = (DefaultTraversalStrategies)super.clone();
            clone2.traversalStrategies = new LinkedHashSet(this.traversalStrategies.size());
            clone2.traversalStrategies.addAll(this.traversalStrategies);
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String toString() {
        return StringFactory.traversalStrategiesString(this);
    }
}

