/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.util.SideEffectHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class DefaultTraversalSideEffects
implements TraversalSideEffects {
    protected Set<String> keys = new HashSet<String>();
    protected Map<String, Object> objectMap = new HashMap<String, Object>();
    protected Map<String, Supplier> supplierMap = new HashMap<String, Supplier>();
    protected Map<String, BinaryOperator> reducerMap = new HashMap<String, BinaryOperator>();
    protected UnaryOperator sackSplitOperator = null;
    protected BinaryOperator sackMergeOperator = null;
    protected Supplier sackInitialValue = null;

    @Override
    public boolean exists(String key) {
        return this.keys.contains(key);
    }

    @Override
    public <V> V get(String key) throws IllegalArgumentException {
        Object value2 = this.objectMap.get(key);
        if (null != value2) {
            return (V)value2;
        }
        V v = this.getSupplier(key).get();
        this.objectMap.put(key, v);
        return v;
    }

    @Override
    public void set(String key, Object value2) throws IllegalArgumentException {
        SideEffectHelper.validateSideEffectValue(value2);
        if (!this.keys.contains(key)) {
            throw TraversalSideEffects.Exceptions.sideEffectKeyDoesNotExist(key);
        }
        this.objectMap.put(key, value2);
    }

    @Override
    public void add(String key, Object value2) throws IllegalArgumentException {
        SideEffectHelper.validateSideEffectValue(value2);
        this.set(key, this.getReducer(key).apply(this.get(key), value2));
    }

    @Override
    public <V> void register(String key, Supplier<V> initialValue, BinaryOperator<V> reducer) {
        SideEffectHelper.validateSideEffectKey(key);
        this.keys.add(key);
        if (null != initialValue) {
            this.supplierMap.put(key, initialValue);
        }
        if (null != reducer) {
            this.reducerMap.put(key, reducer);
        }
    }

    @Override
    public <V> void registerIfAbsent(String key, Supplier<V> initialValue, BinaryOperator<V> reducer) {
        SideEffectHelper.validateSideEffectKey(key);
        this.keys.add(key);
        if (null == this.supplierMap.get(key) && null != initialValue) {
            this.supplierMap.put(key, initialValue);
        }
        if (null == this.reducerMap.get(key) && null != reducer) {
            this.reducerMap.put(key, reducer);
        }
    }

    @Override
    public <V> BinaryOperator<V> getReducer(String key) throws IllegalArgumentException {
        if (!this.keys.contains(key)) {
            throw TraversalSideEffects.Exceptions.sideEffectKeyDoesNotExist(key);
        }
        return this.reducerMap.getOrDefault(key, Operator.assign);
    }

    @Override
    public <V> Supplier<V> getSupplier(String key) throws IllegalArgumentException {
        Supplier supplier = this.supplierMap.get(key);
        if (null == supplier) {
            throw TraversalSideEffects.Exceptions.sideEffectKeyDoesNotExist(key);
        }
        return supplier;
    }

    @Override
    public <S> void setSack(Supplier<S> initialValue, UnaryOperator<S> splitOperator, BinaryOperator<S> mergeOperator) {
        this.sackInitialValue = initialValue;
        this.sackSplitOperator = splitOperator;
        this.sackMergeOperator = mergeOperator;
    }

    @Override
    public <S> Supplier<S> getSackInitialValue() {
        return this.sackInitialValue;
    }

    @Override
    public <S> UnaryOperator<S> getSackSplitter() {
        return this.sackSplitOperator;
    }

    @Override
    public <S> BinaryOperator<S> getSackMerger() {
        return this.sackMergeOperator;
    }

    @Override
    public void remove(String key) {
        this.objectMap.remove(key);
        this.supplierMap.remove(key);
        this.reducerMap.remove(key);
        this.keys.remove(key);
    }

    @Override
    public Set<String> keys() {
        return Collections.unmodifiableSet(this.keys);
    }

    @Override
    public void mergeInto(TraversalSideEffects sideEffects) {
        for (String key : this.keys) {
            sideEffects.registerIfAbsent(key, this.supplierMap.get(key), this.reducerMap.get(key));
            if (!this.objectMap.containsKey(key)) continue;
            sideEffects.set(key, this.objectMap.get(key));
        }
    }

    public String toString() {
        return StringFactory.traversalSideEffectsString(this);
    }

    @Override
    public DefaultTraversalSideEffects clone() {
        try {
            DefaultTraversalSideEffects sideEffects = (DefaultTraversalSideEffects)super.clone();
            sideEffects.keys = new HashSet<String>(this.keys);
            sideEffects.objectMap = new HashMap<String, Object>(this.objectMap);
            sideEffects.supplierMap = new HashMap<String, Supplier>(this.supplierMap);
            sideEffects.reducerMap = new HashMap<String, BinaryOperator>(this.reducerMap);
            return sideEffects;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

