/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class BytecodeHelper {
    private BytecodeHelper() {
    }

    public static Bytecode filterInstructions(Bytecode bytecode, Predicate<Bytecode.Instruction> predicate) {
        Bytecode clone2 = new Bytecode();
        for (Bytecode.Instruction instruction : bytecode.getSourceInstructions()) {
            if (!predicate.test(instruction)) continue;
            clone2.addSource(instruction.getOperator(), instruction.getArguments());
        }
        for (Bytecode.Instruction instruction : bytecode.getStepInstructions()) {
            if (!predicate.test(instruction)) continue;
            clone2.addStep(instruction.getOperator(), instruction.getArguments());
        }
        return clone2;
    }

    public static Optional<String> getLambdaLanguage(Bytecode bytecode) {
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            for (Object object : instruction.getArguments()) {
                Optional<String> temp;
                if (object instanceof Lambda) {
                    return Optional.of(((Lambda)object).getLambdaLanguage());
                }
                if (!(object instanceof Bytecode) || !(temp = BytecodeHelper.getLambdaLanguage((Bytecode)object)).isPresent()) continue;
                return temp;
            }
        }
        return Optional.empty();
    }

    public static void removeBindings(Bytecode bytecode) {
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            Object[] arguments = instruction.getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] instanceof Bytecode.Binding) {
                    arguments[i] = ((Bytecode.Binding)arguments[i]).value();
                    continue;
                }
                if (!(arguments[i] instanceof Bytecode)) continue;
                BytecodeHelper.removeBindings((Bytecode)arguments[i]);
            }
        }
    }

    public static void detachElements(Bytecode bytecode) {
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            Object[] arguments = instruction.getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] instanceof Bytecode) {
                    BytecodeHelper.detachElements((Bytecode)arguments[i]);
                    continue;
                }
                if (arguments[i] instanceof List) {
                    ArrayList list2 = new ArrayList();
                    for (Object object : (List)arguments[i]) {
                        list2.add(DetachedFactory.detach(object, false));
                    }
                    arguments[i] = list2;
                    continue;
                }
                arguments[i] = DetachedFactory.detach(arguments[i], false);
            }
        }
    }
}

