/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalExplanation;
import org.javatuples.Triplet;

public abstract class AbstractExplanation {
    protected abstract Stream<String> getStrategyTraversalsAsString();

    protected Stream<String> getTraversalStepsAsString() {
        return Stream.concat(Stream.of(this.getOriginalTraversalAsString()), this.getIntermediates().map(Triplet::getValue2));
    }

    protected abstract String getOriginalTraversalAsString();

    protected abstract Stream<Triplet<String, String, String>> getIntermediates();

    public String toString() {
        return this.prettyPrint(Integer.MAX_VALUE);
    }

    public String prettyPrint() {
        return this.prettyPrint(100);
    }

    public String prettyPrint(int maxLineLength) {
        String originalTraversal = "Original Traversal";
        String finalTraversal = "Final Traversal";
        int maxStrategyColumnLength = this.getStrategyTraversalsAsString().map(String::length).max(Comparator.naturalOrder()).orElse(15);
        int newLineIndent = maxStrategyColumnLength + 10;
        int maxTraversalColumn = maxLineLength - newLineIndent;
        if (maxTraversalColumn < 1) {
            throw new IllegalArgumentException("The maximum line length is too small to present the " + TraversalExplanation.class.getSimpleName() + ": " + maxLineLength);
        }
        int largestTraversalColumn = this.getTraversalStepsAsString().map(s2 -> this.wordWrap((String)s2, maxTraversalColumn, newLineIndent)).flatMap(s2 -> Stream.of(s2.split("\n"))).map(String::trim).map(s2 -> s2.trim().startsWith("[") ? s2 : "   " + s2).map(String::length).max(Comparator.naturalOrder()).get();
        StringBuilder builder = new StringBuilder("Traversal Explanation\n");
        for (int i = 0; i < maxStrategyColumnLength + 7 + largestTraversalColumn; ++i) {
            builder.append("=");
        }
        AbstractExplanation.spacing("Original Traversal", maxStrategyColumnLength, builder);
        builder.append(this.wordWrap(this.getOriginalTraversalAsString(), maxTraversalColumn, newLineIndent));
        builder.append("\n\n");
        List intermediates = this.getIntermediates().collect(Collectors.toList());
        for (Triplet t : intermediates) {
            int i;
            builder.append((String)t.getValue0());
            int spacesToAdd = maxStrategyColumnLength - ((String)t.getValue0()).length() + 1;
            for (i = 0; i < spacesToAdd; ++i) {
                builder.append(" ");
            }
            builder.append("[").append(((String)t.getValue1()).substring(0, 1)).append("]");
            for (i = 0; i < 3; ++i) {
                builder.append(" ");
            }
            builder.append(this.wordWrap((String)t.getValue2(), maxTraversalColumn, newLineIndent)).append("\n");
        }
        AbstractExplanation.spacing("Final Traversal", maxStrategyColumnLength, builder);
        builder.append(this.wordWrap(intermediates.size() > 0 ? (String)((Triplet)intermediates.get(intermediates.size() - 1)).getValue2() : this.getOriginalTraversalAsString(), maxTraversalColumn, newLineIndent));
        return builder.toString();
    }

    public static void spacing(String finalTraversal, int maxStrategyColumnLength, StringBuilder builder) {
        builder.append("\n");
        builder.append(finalTraversal);
        for (int i = 0; i < maxStrategyColumnLength - finalTraversal.length() + 7; ++i) {
            builder.append(" ");
        }
    }

    private String wordWrap(String longString2, int maxLengthPerLine, int newLineIndent) {
        if (longString2.length() <= maxLengthPerLine) {
            return longString2;
        }
        StringBuilder builder = new StringBuilder();
        int counter = 0;
        for (int i = 0; i < longString2.length(); ++i) {
            if (0 == counter) {
                builder.append(longString2.charAt(i));
            } else if (counter < maxLengthPerLine) {
                builder.append(longString2.charAt(i));
            } else {
                builder.append("\n");
                for (int j = 0; j < newLineIndent; ++j) {
                    builder.append(" ");
                }
                builder.append(longString2.charAt(i));
                counter = 0;
            }
            ++counter;
        }
        return builder.toString();
    }
}

