/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.traverser.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterator;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class TraverserSet<S>
extends AbstractSet<Traverser.Admin<S>>
implements Set<Traverser.Admin<S>>,
Queue<Traverser.Admin<S>>,
Serializable {
    private final Map<Traverser.Admin<S>, Traverser.Admin<S>> map = Collections.synchronizedMap(new LinkedHashMap());

    public TraverserSet() {
    }

    public TraverserSet(Traverser.Admin<S> traverser) {
        if (traverser != null) {
            this.map.put(traverser, traverser);
        }
    }

    @Override
    public Iterator<Traverser.Admin<S>> iterator() {
        return this.map.values().iterator();
    }

    public Traverser.Admin<S> get(Traverser.Admin<S> traverser) {
        return this.map.get(traverser);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public long bulkSize() {
        long bulk = 0L;
        for (Traverser.Admin<S> traverser : this.map.values()) {
            bulk += traverser.bulk();
        }
        return bulk;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object traverser) {
        return this.map.containsKey(traverser);
    }

    @Override
    public boolean add(Traverser.Admin<S> traverser) {
        Traverser.Admin<S> existing = this.map.get(traverser);
        if (null == existing) {
            this.map.put(traverser, traverser);
            return true;
        }
        existing.merge(traverser);
        return false;
    }

    @Override
    public boolean offer(Traverser.Admin<S> traverser) {
        return this.add(traverser);
    }

    @Override
    public Traverser.Admin<S> remove() {
        Iterator<Traverser.Admin<S>> iterator2 = this.map.values().iterator();
        if (!iterator2.hasNext()) {
            throw FastNoSuchElementException.instance();
        }
        Traverser.Admin<S> next2 = iterator2.next();
        iterator2.remove();
        return next2;
    }

    @Override
    public Traverser.Admin<S> poll() {
        return this.map.isEmpty() ? null : this.remove();
    }

    @Override
    public Traverser.Admin<S> element() {
        return this.iterator().next();
    }

    @Override
    public Traverser.Admin<S> peek() {
        return this.map.isEmpty() ? null : this.iterator().next();
    }

    @Override
    public boolean remove(Object traverser) {
        return this.map.remove(traverser) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Spliterator<Traverser.Admin<S>> spliterator() {
        return this.map.values().spliterator();
    }

    @Override
    public String toString() {
        return this.map.values().toString();
    }

    public void sort(Comparator<Traverser<S>> comparator) {
        ArrayList list2 = new ArrayList(this.map.size());
        IteratorUtils.removeOnNext(this.map.values().iterator()).forEachRemaining(list2::add);
        Collections.sort(list2, comparator);
        this.map.clear();
        list2.forEach(traverser -> this.map.put((Traverser.Admin<S>)traverser, (Traverser.Admin<S>)traverser));
    }

    public void shuffle() {
        ArrayList list2 = new ArrayList(this.map.size());
        IteratorUtils.removeOnNext(this.map.values().iterator()).forEachRemaining(list2::add);
        Collections.shuffle(list2);
        this.map.clear();
        list2.forEach(traverser -> this.map.put((Traverser.Admin<S>)traverser, (Traverser.Admin<S>)traverser));
    }
}

