/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.LambdaHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.AndStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ClassFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.IsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.OrStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IdentityRemovalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class FilterRankingStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final FilterRankingStrategy INSTANCE = new FilterRankingStrategy();
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> PRIORS = Collections.singleton(IdentityRemovalStrategy.class);

    private FilterRankingStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        boolean modified = true;
        while (modified) {
            modified = false;
            List<Step> steps = traversal.getSteps();
            for (int i = 0; i < steps.size() - 1; ++i) {
                int nextRank;
                Step step = steps.get(i);
                Step nextStep = step.getNextStep();
                if (FilterRankingStrategy.usesLabels(nextStep, step.getLabels()) || (nextRank = FilterRankingStrategy.getStepRank(nextStep)) == 0) continue;
                if (!step.getLabels().isEmpty()) {
                    TraversalHelper.copyLabels(step, nextStep, true);
                    modified = true;
                }
                if (FilterRankingStrategy.getStepRank(step) <= nextRank) continue;
                traversal.removeStep(nextStep);
                traversal.addStep(i, nextStep);
                modified = true;
            }
        }
    }

    private static int getStepRank(Step step) {
        int rank;
        if (!(step instanceof FilterStep) && !(step instanceof OrderGlobalStep)) {
            return 0;
        }
        if (step instanceof IsStep || step instanceof ClassFilterStep) {
            rank = 1;
        } else if (step instanceof HasStep) {
            rank = 2;
        } else if (step instanceof WherePredicateStep && ((WherePredicateStep)step).getLocalChildren().isEmpty()) {
            rank = 3;
        } else if (step instanceof TraversalFilterStep || step instanceof NotStep) {
            rank = 4;
        } else if (step instanceof WhereTraversalStep) {
            rank = 5;
        } else if (step instanceof OrStep) {
            rank = 6;
        } else if (step instanceof AndStep) {
            rank = 7;
        } else if (step instanceof WherePredicateStep) {
            rank = 8;
        } else if (step instanceof DedupGlobalStep) {
            rank = 9;
        } else if (step instanceof OrderGlobalStep) {
            rank = 10;
        } else {
            return 0;
        }
        if (step instanceof TraversalParent) {
            return FilterRankingStrategy.getMaxStepRank((TraversalParent)((Object)step), rank);
        }
        return rank;
    }

    private static int getMaxStepRank(TraversalParent parent, int startRank) {
        int maxStepRank = startRank;
        for (Traversal.Admin traversal : parent.getLocalChildren()) {
            for (Step step : traversal.getSteps()) {
                int stepRank = FilterRankingStrategy.getStepRank(step);
                if (stepRank <= maxStepRank) continue;
                maxStepRank = stepRank;
            }
        }
        return maxStepRank;
    }

    private static boolean usesLabels(Step<?, ?> step, Set<String> labels) {
        if (step instanceof LambdaHolder) {
            return true;
        }
        if (step instanceof Scoping) {
            Set<String> scopes = ((Scoping)((Object)step)).getScopeKeys();
            for (String label : labels) {
                if (!scopes.contains(label)) continue;
                return true;
            }
        }
        return step instanceof TraversalParent && TraversalHelper.anyStepRecursively(s2 -> FilterRankingStrategy.usesLabels(s2, labels), (TraversalParent)((Object)step));
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static FilterRankingStrategy instance() {
        return INSTANCE;
    }
}

