/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tree<T>
extends HashMap<T, Tree<T>>
implements Serializable {
    public Tree() {
    }

    @SafeVarargs
    public Tree(T ... children2) {
        this();
        for (T t : children2) {
            this.put(t, new Tree<T>());
        }
    }

    @SafeVarargs
    public Tree(Map.Entry<T, Tree<T>> ... children2) {
        this();
        for (Map.Entry<T, Tree<T>> entry2 : children2) {
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    public List<Tree<T>> getTreesAtDepth(int depth) {
        List<Tree<T>> currentDepth = Collections.singletonList(this);
        for (int i = 0; i < depth; ++i) {
            if (i == depth - 1) {
                return currentDepth;
            }
            ArrayList<Tree<T>> temp = new ArrayList<Tree<T>>();
            for (Tree<T> t : currentDepth) {
                temp.addAll(t.values());
            }
            currentDepth = temp;
        }
        return Collections.emptyList();
    }

    public List<T> getObjectsAtDepth(int depth) {
        ArrayList list2 = new ArrayList();
        for (Tree<T> t : this.getTreesAtDepth(depth)) {
            list2.addAll(t.keySet());
        }
        return list2;
    }

    public List<Tree<T>> getLeafTrees() {
        ArrayList<Tree<T>> leaves = new ArrayList<Tree<T>>();
        List<Tree> currentDepth = Collections.singletonList(this);
        boolean allLeaves = false;
        while (!allLeaves) {
            allLeaves = true;
            ArrayList<Tree> temp = new ArrayList<Tree>();
            for (Tree t : currentDepth) {
                if (t.isLeaf()) {
                    for (Map.Entry t2 : t.entrySet()) {
                        leaves.add(new Tree<T>(t2));
                    }
                    continue;
                }
                allLeaves = false;
                temp.addAll(t.values());
            }
            currentDepth = temp;
        }
        return leaves;
    }

    public List<T> getLeafObjects() {
        ArrayList leaves = new ArrayList();
        for (Tree<T> t : this.getLeafTrees()) {
            leaves.addAll(t.keySet());
        }
        return leaves;
    }

    public boolean isLeaf() {
        Collection values2 = this.values();
        return ((Tree)values2.iterator().next()).isEmpty();
    }

    public void addTree(Tree<T> tree) {
        tree.forEach((k, t) -> {
            if (this.containsKey(k)) {
                ((Tree)this.get(k)).addTree((Tree<T>)t);
            } else {
                this.put(k, t);
            }
        });
    }

    public List<Tree<T>> splitParents() {
        if (this.keySet().size() == 1) {
            return Collections.singletonList(this);
        }
        ArrayList parents2 = new ArrayList();
        this.forEach((k, t) -> {
            Tree parentTree = new Tree();
            parentTree.put(k, t);
            parents2.add(parentTree);
        });
        return parents2;
    }
}

