/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;

public abstract class SupplyingBarrierStep<S, E>
extends AbstractStep<S, E>
implements Barrier<Boolean> {
    private boolean done = false;

    public SupplyingBarrierStep(Traversal.Admin traversal) {
        super(traversal);
    }

    protected abstract E supply();

    @Override
    public void addStarts(Iterator<Traverser.Admin<S>> starts2) {
        if (starts2.hasNext()) {
            this.done = false;
            super.addStarts(starts2);
        }
    }

    @Override
    public void addStart(Traverser.Admin<S> start) {
        this.done = false;
        super.addStart(start);
    }

    @Override
    public void reset() {
        super.reset();
        this.done = false;
    }

    @Override
    public Traverser.Admin<E> processNextStart() {
        if (this.done) {
            throw FastNoSuchElementException.instance();
        }
        this.processAllStarts();
        this.done = true;
        return this.getTraversal().asAdmin().getTraverserGenerator().generate(this.supply(), this, 1L);
    }

    @Override
    public SupplyingBarrierStep<S, E> clone() {
        SupplyingBarrierStep clone2 = (SupplyingBarrierStep)super.clone();
        clone2.done = false;
        return clone2;
    }

    @Override
    public void processAllStarts() {
        while (this.starts.hasNext()) {
            this.starts.next();
        }
    }

    @Override
    public boolean hasNextBarrier() {
        return !this.done;
    }

    @Override
    public Boolean nextBarrier() throws NoSuchElementException {
        this.processAllStarts();
        this.done = true;
        return true;
    }

    @Override
    public void addBarrier(Boolean barrier) {
        this.done = false;
    }

    @Override
    public void done() {
        this.done = true;
    }

    @Override
    public MemoryComputeKey<Boolean> getMemoryComputeKey() {
        return MemoryComputeKey.of(this.getId(), Operator.and, false, true);
    }
}

