/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class Parameters
implements Cloneable,
Serializable {
    public static final Parameters EMPTY = new Parameters();
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Map<Object, List<Object>> parameters = new HashMap<Object, List<Object>>();
    private Set<String> referencedLabels = new HashSet<String>();
    private List<Traversal.Admin<?, ?>> traversals = new ArrayList();

    public boolean contains(Object key) {
        return this.parameters.containsKey(key);
    }

    public void rename(Object oldKey, Object newKey) {
        this.parameters.put(newKey, this.parameters.remove(oldKey));
    }

    public <S, E> List<E> get(Traverser.Admin<S> traverser, Object key, Supplier<E> defaultValue2) {
        List<Object> values2 = this.parameters.get(key);
        if (null == values2) {
            return Collections.singletonList(defaultValue2.get());
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Object value2 : values2) {
            result2.add(value2 instanceof Traversal.Admin ? TraversalUtil.apply(traverser, (Traversal.Admin)value2) : value2);
        }
        return result2;
    }

    public <E> List<E> get(Object key, Supplier<E> defaultValue2) {
        List<Object> list2 = this.parameters.get(key);
        return null == list2 ? (null == defaultValue2 ? Collections.emptyList() : Collections.singletonList(defaultValue2.get())) : list2;
    }

    public Object remove(Object key) {
        List<Object> o = this.parameters.remove(key);
        if (IteratorUtils.anyMatch(o.iterator(), p -> p instanceof Traversal.Admin)) {
            this.traversals.clear();
            this.traversals = new ArrayList();
            for (List<Object> list2 : this.parameters.values()) {
                for (Object object : list2) {
                    if (!(object instanceof Traversal.Admin)) continue;
                    Traversal.Admin t = (Traversal.Admin)object;
                    this.addTraversal(t);
                }
            }
        }
        return o;
    }

    public <S> Object[] getKeyValues(Traverser.Admin<S> traverser, Object ... exceptKeys) {
        if (this.parameters.isEmpty()) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> keyValues = new ArrayList<Object>();
        for (Map.Entry<Object, List<Object>> entry2 : this.parameters.entrySet()) {
            if (ArrayUtils.contains(exceptKeys, entry2.getKey())) continue;
            for (Object value2 : entry2.getValue()) {
                keyValues.add(entry2.getKey() instanceof Traversal.Admin ? TraversalUtil.apply(traverser, (Traversal.Admin)entry2.getKey()) : entry2.getKey());
                keyValues.add(value2 instanceof Traversal.Admin ? TraversalUtil.apply(traverser, (Traversal.Admin)value2) : value2);
            }
        }
        return keyValues.toArray(new Object[keyValues.size()]);
    }

    public Map<Object, List<Object>> getRaw(Object ... exceptKeys) {
        if (this.parameters.isEmpty()) {
            return Collections.emptyMap();
        }
        List<Object> exceptions = Arrays.asList(exceptKeys);
        HashMap<Object, List<Object>> raw2 = new HashMap<Object, List<Object>>();
        for (Map.Entry<Object, List<Object>> entry2 : this.parameters.entrySet()) {
            if (exceptions.contains(entry2.getKey())) continue;
            raw2.put(entry2.getKey(), entry2.getValue());
        }
        return Collections.unmodifiableMap(raw2);
    }

    public void set(TraversalParent parent, Object ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw Element.Exceptions.providedKeyValuesMustBeAMultipleOfTwo();
        }
        for (int ix = 0; ix < keyValues.length; ix += 2) {
            if (!(keyValues[ix] instanceof String || keyValues[ix] instanceof T || keyValues[ix] instanceof Traversal)) {
                throw new IllegalArgumentException("The provided key/value array must have a String, T, or Traversal on even array indices");
            }
            if (keyValues[ix + 1] == null) continue;
            for (int iy = 0; iy < 2; ++iy) {
                if (!(keyValues[ix + iy] instanceof Traversal.Admin)) continue;
                Traversal.Admin t = (Traversal.Admin)keyValues[ix + iy];
                this.addTraversal(t);
                if (parent == null) continue;
                parent.integrateChild(t);
            }
            List<Object> values2 = this.parameters.get(keyValues[ix]);
            if (null == values2) {
                values2 = new ArrayList<Object>();
                values2.add(keyValues[ix + 1]);
                this.parameters.put(keyValues[ix], values2);
                continue;
            }
            values2.add(keyValues[ix + 1]);
        }
    }

    public <S, E> List<Traversal.Admin<S, E>> getTraversals() {
        return this.traversals;
    }

    public Set<String> getReferencedLabels() {
        return this.referencedLabels;
    }

    public Parameters clone() {
        try {
            Parameters clone2 = (Parameters)super.clone();
            clone2.parameters = new HashMap<Object, List<Object>>();
            clone2.traversals = new ArrayList();
            for (Map.Entry<Object, List<Object>> entry2 : this.parameters.entrySet()) {
                ArrayList<Object> values2 = new ArrayList<Object>();
                for (Object value2 : entry2.getValue()) {
                    if (value2 instanceof Traversal.Admin) {
                        Traversal.Admin traversalClone = ((Traversal.Admin)value2).clone();
                        clone2.traversals.add(traversalClone);
                        values2.add(traversalClone);
                        continue;
                    }
                    values2.add(value2);
                }
                if (entry2.getKey() instanceof Traversal.Admin) {
                    Traversal.Admin traversalClone = ((Traversal.Admin)entry2.getKey()).clone();
                    clone2.traversals.add(traversalClone);
                    clone2.parameters.put(traversalClone, values2);
                    continue;
                }
                clone2.parameters.put(entry2.getKey(), values2);
            }
            clone2.referencedLabels = new HashSet<String>(this.referencedLabels);
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public int hashCode() {
        int result2 = 1;
        for (Map.Entry<Object, List<Object>> entry2 : this.parameters.entrySet()) {
            result2 ^= entry2.getKey().hashCode();
            for (Object value2 : entry2.getValue()) {
                result2 ^= Integer.rotateLeft(value2.hashCode(), entry2.getKey().hashCode());
            }
        }
        return result2;
    }

    public String toString() {
        return this.parameters.toString();
    }

    private void addTraversal(Traversal.Admin t) {
        this.traversals.add(t);
        for (Step ss : t.getSteps()) {
            if (!(ss instanceof Scoping)) continue;
            for (String label : ((Scoping)((Object)ss)).getScopeKeys()) {
                this.referencedLabels.add(label);
            }
        }
    }
}

