/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class MutablePath
implements Path,
Serializable {
    protected final List<Object> objects;
    protected final List<Set<String>> labels;

    protected MutablePath() {
        this(10);
    }

    private MutablePath(int capacity) {
        this.objects = new ArrayList<Object>(capacity);
        this.labels = new ArrayList<Set<String>>(capacity);
    }

    public static Path make() {
        return new MutablePath();
    }

    @Override
    public MutablePath clone() {
        MutablePath clone2 = new MutablePath(this.objects.size());
        clone2.objects.addAll(this.objects);
        for (Set<String> labels : this.labels) {
            clone2.labels.add(new LinkedHashSet<String>(labels));
        }
        return clone2;
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public <A> A head() {
        return (A)this.objects.get(this.objects.size() - 1);
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public Path extend(Object object, Set<String> labels) {
        this.objects.add(object);
        this.labels.add(new LinkedHashSet<String>(labels));
        return this;
    }

    @Override
    public Path extend(Set<String> labels) {
        if (!labels.isEmpty() && !this.labels.get(this.labels.size() - 1).containsAll(labels)) {
            this.labels.get(this.labels.size() - 1).addAll(labels);
        }
        return this;
    }

    @Override
    public Path retract(Set<String> removeLabels) {
        for (int i = this.labels.size() - 1; i >= 0; --i) {
            this.labels.get(i).removeAll(removeLabels);
            if (!this.labels.get(i).isEmpty()) continue;
            this.labels.remove(i);
            this.objects.remove(i);
        }
        return this;
    }

    @Override
    public <A> A get(int index2) {
        return (A)this.objects.get(index2);
    }

    @Override
    public <A> A get(Pop pop, String label) {
        if (Pop.mixed == pop) {
            return this.get(label);
        }
        if (Pop.all == pop) {
            if (this.hasLabel(label)) {
                Object object = this.get(label);
                if (object instanceof List) {
                    return object;
                }
                return (A)Collections.singletonList(object);
            }
            return (A)Collections.emptyList();
        }
        if (Pop.last == pop) {
            for (int i = this.labels.size() - 1; i >= 0; --i) {
                if (!this.labels.get(i).contains(label)) continue;
                return (A)this.objects.get(i);
            }
        } else {
            for (int i = 0; i != this.labels.size(); ++i) {
                if (!this.labels.get(i).contains(label)) continue;
                return (A)this.objects.get(i);
            }
        }
        throw Path.Exceptions.stepWithProvidedLabelDoesNotExist(label);
    }

    @Override
    public boolean hasLabel(String label) {
        for (Set<String> set2 : this.labels) {
            if (!set2.contains(label)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object> objects() {
        return Collections.unmodifiableList(this.objects);
    }

    @Override
    public List<Set<String>> labels() {
        return Collections.unmodifiableList(this.labels);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.objects.iterator();
    }

    public String toString() {
        return StringFactory.pathString(this);
    }

    public int hashCode() {
        return this.objects.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Path)) {
            return false;
        }
        Path otherPath = (Path)other;
        if (otherPath.size() != this.objects.size()) {
            return false;
        }
        List<Object> otherPathObjects = otherPath.objects();
        List<Set<String>> otherPathLabels = otherPath.labels();
        for (int i = this.objects.size() - 1; i >= 0; --i) {
            if (!this.objects.get(i).equals(otherPathObjects.get(i))) {
                return false;
            }
            if (this.labels.get(i).equals(otherPathLabels.get(i))) continue;
            return false;
        }
        return true;
    }
}

