/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class ImmutablePath
implements Path,
Serializable,
Cloneable {
    private static final ImmutablePath TAIL_PATH = new ImmutablePath(null, null, null);
    private ImmutablePath previousPath;
    private Object currentObject;
    private Set<String> currentLabels;

    public static Path make() {
        return TAIL_PATH;
    }

    @Override
    public ImmutablePath clone() {
        return this;
    }

    private ImmutablePath(ImmutablePath previousPath, Object currentObject, Set<String> currentLabels) {
        this.previousPath = previousPath;
        this.currentObject = currentObject;
        this.currentLabels = currentLabels;
    }

    private final boolean isTail() {
        return null == this.currentObject;
    }

    @Override
    public boolean isEmpty() {
        return this.isTail();
    }

    @Override
    public int size() {
        int counter = 0;
        ImmutablePath currentPath = this;
        while (!currentPath.isTail()) {
            ++counter;
            currentPath = currentPath.previousPath;
        }
        return counter;
    }

    @Override
    public <A> A head() {
        return (A)this.currentObject;
    }

    @Override
    public Path extend(Object object, Set<String> labels) {
        return new ImmutablePath(this, object, labels);
    }

    @Override
    public Path extend(Set<String> labels) {
        if (labels.isEmpty() || this.currentLabels.containsAll(labels)) {
            return this;
        }
        LinkedHashSet<String> newLabels = new LinkedHashSet<String>();
        newLabels.addAll(this.currentLabels);
        newLabels.addAll(labels);
        return new ImmutablePath(this.previousPath, this.currentObject, newLabels);
    }

    @Override
    public Path retract(Set<String> labels) {
        if (labels.isEmpty()) {
            return this;
        }
        ArrayList<ImmutablePath> immutablePaths = new ArrayList<ImmutablePath>();
        ImmutablePath currentPath = this;
        while (!currentPath.isTail()) {
            immutablePaths.add(0, currentPath);
            currentPath = currentPath.previousPath;
        }
        Path newPath = TAIL_PATH;
        for (ImmutablePath immutablePath : immutablePaths) {
            LinkedHashSet<String> temp = new LinkedHashSet<String>(immutablePath.currentLabels);
            temp.removeAll(labels);
            if (temp.isEmpty()) continue;
            newPath = newPath.extend(immutablePath.currentObject, temp);
        }
        return newPath;
    }

    @Override
    public <A> A get(int index2) {
        int counter = this.size();
        ImmutablePath currentPath = this;
        while (index2 != --counter) {
            currentPath = currentPath.previousPath;
        }
        return (A)currentPath.currentObject;
    }

    @Override
    public <A> A get(Pop pop, String label) {
        if (Pop.mixed == pop) {
            return this.get(label);
        }
        if (Pop.all == pop) {
            ArrayList<Object> list2 = new ArrayList<Object>();
            ImmutablePath currentPath = this;
            while (!currentPath.isTail()) {
                if (currentPath.currentLabels.contains(label)) {
                    list2.add(0, currentPath.currentObject);
                }
                currentPath = currentPath.previousPath;
            }
            return (A)list2;
        }
        if (Pop.last == pop) {
            ImmutablePath currentPath = this;
            while (true) {
                if (currentPath.isTail()) {
                    throw Path.Exceptions.stepWithProvidedLabelDoesNotExist(label);
                }
                if (currentPath.currentLabels.contains(label)) {
                    return (A)currentPath.currentObject;
                }
                currentPath = currentPath.previousPath;
            }
        }
        Object found = null;
        ImmutablePath currentPath = this;
        while (!currentPath.isTail()) {
            if (currentPath.currentLabels.contains(label)) {
                found = currentPath.currentObject;
            }
            currentPath = currentPath.previousPath;
        }
        if (null == found) {
            throw Path.Exceptions.stepWithProvidedLabelDoesNotExist(label);
        }
        return (A)found;
    }

    @Override
    public boolean hasLabel(String label) {
        ImmutablePath currentPath = this;
        while (!currentPath.isTail()) {
            if (currentPath.currentLabels.contains(label)) {
                return true;
            }
            currentPath = currentPath.previousPath;
        }
        return false;
    }

    @Override
    public List<Object> objects() {
        ArrayList<Object> objects = new ArrayList<Object>();
        ImmutablePath currentPath = this;
        while (!currentPath.isTail()) {
            objects.add(0, currentPath.currentObject);
            currentPath = currentPath.previousPath;
        }
        return Collections.unmodifiableList(objects);
    }

    @Override
    public List<Set<String>> labels() {
        ArrayList<Set<String>> labels = new ArrayList<Set<String>>();
        ImmutablePath currentPath = this;
        while (!currentPath.isTail()) {
            labels.add(0, currentPath.currentLabels);
            currentPath = currentPath.previousPath;
        }
        return Collections.unmodifiableList(labels);
    }

    public String toString() {
        return StringFactory.pathString(this);
    }

    public int hashCode() {
        int[] hashCodes = new int[this.size()];
        int index2 = hashCodes.length - 1;
        ImmutablePath currentPath = this;
        while (!currentPath.isTail()) {
            hashCodes[index2] = currentPath.currentObject.hashCode();
            currentPath = currentPath.previousPath;
            --index2;
        }
        int hashCode = 1;
        for (int hash2 : hashCodes) {
            hashCode = hashCode * 31 + hash2;
        }
        return hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Path)) {
            return false;
        }
        Path otherPath = (Path)other;
        int size2 = this.size();
        if (otherPath.size() != size2) {
            return false;
        }
        if (size2 > 0) {
            ImmutablePath currentPath = this;
            List<Object> otherObjects = otherPath.objects();
            List<Set<String>> otherLabels = otherPath.labels();
            for (int i = otherLabels.size() - 1; i >= 0; --i) {
                if (currentPath.isTail()) {
                    return true;
                }
                if (!currentPath.currentObject.equals(otherObjects.get(i)) || !currentPath.currentLabels.equals(otherLabels.get(i))) {
                    return false;
                }
                currentPath = currentPath.previousPath;
            }
        }
        return true;
    }

    @Override
    public boolean popEquals(Pop pop, Object other) {
        if (!(other instanceof Path)) {
            return false;
        }
        Path otherPath = (Path)other;
        ImmutablePath currentPath = this;
        while (!currentPath.isTail()) {
            for (String label : currentPath.currentLabels) {
                if (otherPath.hasLabel(label) && this.get(pop, label).equals(otherPath.get(pop, label))) continue;
                return false;
            }
            currentPath = currentPath.previousPath;
        }
        return true;
    }

    @Override
    public boolean isSimple() {
        HashSet<Object> objects = new HashSet<Object>();
        ImmutablePath currentPath = this;
        while (!currentPath.isTail()) {
            if (objects.contains(currentPath.currentObject)) {
                return false;
            }
            objects.add(currentPath.currentObject);
            currentPath = currentPath.previousPath;
        }
        return true;
    }
}

