/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;

public final class ExpandableStepIterator<S>
implements Iterator<Traverser.Admin<S>>,
Serializable {
    private final TraverserSet<S> traverserSet = new TraverserSet();
    private final Step<S, ?> hostStep;

    public ExpandableStepIterator(Step<S, ?> hostStep) {
        this.hostStep = hostStep;
    }

    @Override
    public boolean hasNext() {
        return !this.traverserSet.isEmpty() || this.hostStep.getPreviousStep().hasNext();
    }

    @Override
    public Traverser.Admin<S> next() {
        if (!this.traverserSet.isEmpty()) {
            return this.traverserSet.remove();
        }
        if (this.hostStep.getPreviousStep().hasNext()) {
            return (Traverser.Admin)this.hostStep.getPreviousStep().next();
        }
        return this.traverserSet.remove();
    }

    public void add(Iterator<Traverser.Admin<S>> iterator2) {
        iterator2.forEachRemaining(this.traverserSet::add);
    }

    public void add(Traverser.Admin<S> traverser) {
        this.traverserSet.add(traverser);
    }

    public String toString() {
        return this.traverserSet.toString();
    }

    public void clear() {
        this.traverserSet.clear();
    }
}

