/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GraphComputing;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;

public abstract class ComputerAwareStep<S, E>
extends AbstractStep<S, E>
implements GraphComputing {
    private Iterator<Traverser.Admin<E>> previousIterator = EmptyIterator.instance();

    public ComputerAwareStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected Traverser.Admin<E> processNextStart() throws NoSuchElementException {
        while (!this.previousIterator.hasNext()) {
            this.previousIterator = this.traverserStepIdAndLabelsSetByChild ? this.computerAlgorithm() : this.standardAlgorithm();
        }
        return this.previousIterator.next();
    }

    @Override
    public void onGraphComputer() {
        this.traverserStepIdAndLabelsSetByChild = true;
    }

    @Override
    public ComputerAwareStep<S, E> clone() {
        ComputerAwareStep clone2 = (ComputerAwareStep)super.clone();
        clone2.previousIterator = EmptyIterator.instance();
        return clone2;
    }

    @Override
    public void reset() {
        super.reset();
        this.previousIterator = EmptyIterator.instance();
    }

    protected abstract Iterator<Traverser.Admin<E>> standardAlgorithm() throws NoSuchElementException;

    protected abstract Iterator<Traverser.Admin<E>> computerAlgorithm() throws NoSuchElementException;

    public static class EndStep<S>
    extends AbstractStep<S, S>
    implements GraphComputing {
        public EndStep(Traversal.Admin traversal) {
            super(traversal);
        }

        @Override
        protected Traverser.Admin<S> processNextStart() throws NoSuchElementException {
            Object start = this.starts.next();
            if (this.traverserStepIdAndLabelsSetByChild) {
                ComputerAwareStep step = (ComputerAwareStep)((Object)this.getTraversal().getParent());
                start.setStepId(step.getNextStep().getId());
                start.addLabels(step.getLabels());
            }
            return start;
        }

        @Override
        public String toString() {
            return StringFactory.stepString(this, new Object[0]);
        }

        @Override
        public void onGraphComputer() {
            this.traverserStepIdAndLabelsSetByChild = true;
        }
    }
}

