/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class BulkSet<S>
extends AbstractSet<S>
implements Set<S>,
Serializable {
    private final Map<S, Long> map = new LinkedHashMap<S, Long>();

    @Override
    public int size() {
        return (int)this.longSize();
    }

    public int uniqueSize() {
        return this.map.size();
    }

    public long longSize() {
        return this.map.values().stream().collect(Collectors.summingLong(Long::longValue));
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object s2) {
        return this.map.containsKey(s2);
    }

    @Override
    public boolean add(S s2) {
        return this.add(s2, 1L);
    }

    @Override
    public boolean addAll(Collection<? extends S> collection2) {
        if (collection2 instanceof BulkSet) {
            ((BulkSet)collection2).map.forEach(this::add);
        } else {
            collection2.iterator().forEachRemaining(this::add);
        }
        return true;
    }

    public void forEach(BiConsumer<S, Long> consumer) {
        this.map.forEach(consumer);
    }

    public Map<S, Long> asBulk() {
        return Collections.unmodifiableMap(this.map);
    }

    public boolean add(S s2, long bulk) {
        Long current = this.map.get(s2);
        if (current != null) {
            this.map.put(s2, current + bulk);
            return false;
        }
        this.map.put(s2, bulk);
        return true;
    }

    public long get(S s2) {
        Long bulk = this.map.get(s2);
        return null == bulk ? 0L : bulk;
    }

    @Override
    public boolean remove(Object s2) {
        return this.map.remove(s2) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Spliterator<S> spliterator() {
        return this.toList().spliterator();
    }

    @Override
    public boolean removeAll(Collection<?> collection2) {
        Objects.requireNonNull(collection2);
        boolean modified = false;
        for (Object object : collection2) {
            if (null == this.map.remove(object)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof BulkSet && this.map.equals(((BulkSet)object).map);
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    private List<S> toList() {
        ArrayList list2 = new ArrayList();
        this.map.forEach((? super K k, ? super V v) -> {
            for (long i = 0L; i < v; ++i) {
                list2.add(k);
            }
        });
        return list2;
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            final Iterator<Map.Entry<S, Long>> entryIterator;
            S lastObject;
            long lastCount;
            {
                this.entryIterator = BulkSet.this.map.entrySet().iterator();
                this.lastObject = null;
                this.lastCount = 0L;
            }

            @Override
            public boolean hasNext() {
                return this.lastCount > 0L || this.entryIterator.hasNext();
            }

            @Override
            public S next() {
                if (this.lastCount > 0L) {
                    --this.lastCount;
                    return this.lastObject;
                }
                Map.Entry entry2 = this.entryIterator.next();
                if (entry2.getValue() == 1L) {
                    return entry2.getKey();
                }
                this.lastObject = entry2.getKey();
                this.lastCount = entry2.getValue() - 1L;
                return this.lastObject;
            }
        };
    }
}

