/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.ProfilingAware;
import org.apache.tinkerpop.gremlin.process.traversal.step.SideEffectCapable;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.HashMapSupplier;

public final class GroupSideEffectStep<S, K, V>
extends SideEffectStep<S>
implements SideEffectCapable<Map<K, ?>, Map<K, V>>,
TraversalParent,
ByModulating,
ProfilingAware {
    private char state = (char)107;
    private Traversal.Admin<S, K> keyTraversal;
    private Traversal.Admin<S, V> valueTraversal;
    private Barrier barrierStep;
    private boolean resetBarrierForProfiling = false;
    private String sideEffectKey;

    public GroupSideEffectStep(Traversal.Admin traversal, String sideEffectKey) {
        super(traversal);
        this.sideEffectKey = sideEffectKey;
        this.valueTraversal = this.integrateChild(__.fold().asAdmin());
        this.barrierStep = GroupStep.determineBarrierStep(this.valueTraversal);
        this.getTraversal().getSideEffects().registerIfAbsent(this.sideEffectKey, HashMapSupplier.instance(), new GroupStep.GroupBiOperator(null == this.barrierStep ? Operator.assign : this.barrierStep.getMemoryComputeKey().getReducer()));
    }

    @Override
    public void prepareForProfiling() {
        this.resetBarrierForProfiling = this.barrierStep != null;
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> kvTraversal) {
        if ('k' == this.state) {
            this.keyTraversal = this.integrateChild(kvTraversal);
            this.state = (char)118;
        } else if ('v' == this.state) {
            this.valueTraversal = this.integrateChild(GroupStep.convertValueTraversal(kvTraversal));
            this.barrierStep = GroupStep.determineBarrierStep(this.valueTraversal);
            this.getTraversal().getSideEffects().register(this.sideEffectKey, null, new GroupStep.GroupBiOperator(null == this.barrierStep ? Operator.assign : this.barrierStep.getMemoryComputeKey().getReducer()));
            this.state = (char)120;
        } else {
            throw new IllegalStateException("The key and value traversals for group()-step have already been set: " + this);
        }
    }

    @Override
    protected void sideEffect(Traverser.Admin<S> traverser) {
        HashMap<K, Object> map2 = new HashMap<K, Object>(1);
        this.valueTraversal.reset();
        this.valueTraversal.addStart(traverser);
        if (this.resetBarrierForProfiling) {
            this.barrierStep = GroupStep.determineBarrierStep(this.valueTraversal);
            this.resetBarrierForProfiling = false;
        }
        if (null == this.barrierStep) {
            if (this.valueTraversal.hasNext()) {
                map2.put(TraversalUtil.applyNullable(traverser, this.keyTraversal), this.valueTraversal.next());
            }
        } else if (this.barrierStep.hasNextBarrier()) {
            map2.put(TraversalUtil.applyNullable(traverser, this.keyTraversal), this.barrierStep.nextBarrier());
        }
        if (!map2.isEmpty()) {
            this.getTraversal().getSideEffects().add(this.sideEffectKey, map2);
        }
    }

    @Override
    public String getSideEffectKey() {
        return this.sideEffectKey;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.sideEffectKey, this.keyTraversal, this.valueTraversal);
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        ArrayList children2 = new ArrayList(2);
        if (null != this.keyTraversal) {
            children2.add(this.keyTraversal);
        }
        children2.add(this.valueTraversal);
        return children2;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.BULK, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public GroupSideEffectStep<S, K, V> clone() {
        GroupSideEffectStep clone2 = (GroupSideEffectStep)super.clone();
        if (null != this.keyTraversal) {
            clone2.keyTraversal = this.keyTraversal.clone();
        }
        clone2.valueTraversal = this.valueTraversal.clone();
        clone2.barrierStep = GroupStep.determineBarrierStep(clone2.valueTraversal);
        return clone2;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.keyTraversal);
        this.integrateChild(this.valueTraversal);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode() ^ this.sideEffectKey.hashCode();
        if (this.keyTraversal != null) {
            result2 ^= this.keyTraversal.hashCode();
        }
        return result2 ^= this.valueTraversal.hashCode();
    }

    @Override
    public Map<K, V> generateFinalResult(Map<K, ?> object) {
        return GroupStep.doFinalReduction(object, this.valueTraversal);
    }
}

