/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.util.iterator.ArrayIterator;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class UnfoldStep<S, E>
extends FlatMapStep<S, E> {
    public UnfoldStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected Iterator<E> flatMap(Traverser.Admin<S> traverser) {
        Object s2 = traverser.get();
        if (s2 instanceof Iterator) {
            return (Iterator)s2;
        }
        if (s2 instanceof Iterable) {
            return ((Iterable)s2).iterator();
        }
        if (s2 instanceof Map) {
            return ((Map)s2).entrySet().iterator();
        }
        if (s2.getClass().isArray()) {
            return this.handleArrays(s2);
        }
        return IteratorUtils.of(s2);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    private final Iterator<E> handleArrays(Object array2) {
        if (array2 instanceof Object[]) {
            return new ArrayIterator<Object>((Object[])array2);
        }
        int len = Array.getLength(array2);
        Object[] objectArray = new Object[len];
        for (int i = 0; i < len; ++i) {
            objectArray[i] = Array.get(array2, i);
        }
        return new ArrayIterator<Object>(objectArray);
    }
}

