/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.RangeLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TailLocalStep<S>
extends MapStep<S, S> {
    private final long limit;

    public TailLocalStep(Traversal.Admin traversal, long limit) {
        super(traversal);
        this.limit = limit;
    }

    @Override
    protected S map(Traverser.Admin<S> traverser) {
        Object start = traverser.get();
        long high = start instanceof Map ? (long)((Map)start).size() : (start instanceof Collection ? (long)((Collection)start).size() : (start instanceof Path ? (long)((Path)start).size() : (start instanceof Iterable ? IteratorUtils.count((Iterable)start) : this.limit)));
        long low = high - this.limit;
        Object result2 = RangeLocalStep.applyRange(start, low, high);
        return (S)result2;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.limit);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Long.hashCode(this.limit);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }
}

