/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class SelectStep<S, E>
extends MapStep<S, Map<String, E>>
implements Scoping,
TraversalParent,
PathProcessor,
ByModulating {
    private TraversalRing<Object, E> traversalRing = new TraversalRing(new Traversal.Admin[0]);
    private final Pop pop;
    private final List<String> selectKeys;
    private final Set<String> selectKeysSet;
    private Set<String> keepLabels;

    public SelectStep(Traversal.Admin traversal, Pop pop, String ... selectKeys) {
        super(traversal);
        this.pop = pop;
        this.selectKeys = Arrays.asList(selectKeys);
        this.selectKeysSet = Collections.unmodifiableSet(new HashSet<String>(this.selectKeys));
        if (this.selectKeys.size() < 2) {
            throw new IllegalArgumentException("At least two select keys must be provided: " + this);
        }
    }

    @Override
    protected Map<String, E> map(Traverser.Admin<S> traverser) {
        LinkedHashMap<String, E> bindings = new LinkedHashMap<String, E>(this.selectKeys.size(), 1.0f);
        for (String selectKey : this.selectKeys) {
            Object end = this.getNullableScopeValue(this.pop, selectKey, traverser);
            if (null != end) {
                bindings.put(selectKey, TraversalUtil.applyNullable(end, this.traversalRing.next()));
                continue;
            }
            this.traversalRing.reset();
            return null;
        }
        this.traversalRing.reset();
        return bindings;
    }

    @Override
    public void reset() {
        super.reset();
        this.traversalRing.reset();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[]{this.pop, this.selectKeys, this.traversalRing});
    }

    @Override
    public SelectStep<S, E> clone() {
        SelectStep clone2 = (SelectStep)super.clone();
        clone2.traversalRing = this.traversalRing.clone();
        return clone2;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode() ^ this.traversalRing.hashCode() ^ this.selectKeys.hashCode();
        if (null != this.pop) {
            result2 ^= this.pop.hashCode();
        }
        return result2;
    }

    public List<Traversal.Admin<Object, E>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> selectTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(selectTraversal));
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.selectKeysSet;
    }

    public Map<String, Traversal.Admin<Object, E>> getByTraversals() {
        HashMap<String, Traversal.Admin<Object, E>> map2 = new HashMap<String, Traversal.Admin<Object, E>>();
        this.traversalRing.reset();
        for (String as : this.selectKeys) {
            map2.put(as, this.traversalRing.next());
        }
        return map2;
    }

    public Pop getPop() {
        return this.pop;
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }

    @Override
    protected Traverser.Admin<Map<String, E>> processNextStart() {
        return PathProcessor.processTraverserPathLabels(super.processNextStart(), this.keepLabels);
    }
}

