/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;

public final class SampleLocalStep<S>
extends MapStep<S, S> {
    private static final Random RANDOM = new Random();
    private final int amountToSample;

    public SampleLocalStep(Traversal.Admin traversal, int amountToSample) {
        super(traversal);
        this.amountToSample = amountToSample;
    }

    @Override
    protected S map(Traverser.Admin<S> traverser) {
        Object start = traverser.get();
        if (start instanceof Map) {
            return this.mapMap((Map)start);
        }
        if (start instanceof Collection) {
            return this.mapCollection((Collection)start);
        }
        return (S)start;
    }

    private S mapCollection(Collection collection2) {
        if (collection2.size() <= this.amountToSample) {
            return (S)collection2;
        }
        ArrayList original = new ArrayList(collection2);
        ArrayList target = new ArrayList();
        while (target.size() < this.amountToSample) {
            target.add(original.remove(RANDOM.nextInt(original.size())));
        }
        return (S)target;
    }

    private S mapMap(Map map2) {
        if (map2.size() <= this.amountToSample) {
            return (S)map2;
        }
        ArrayList original = new ArrayList(map2.entrySet());
        LinkedHashMap target = new LinkedHashMap(this.amountToSample);
        while (target.size() < this.amountToSample) {
            Map.Entry entry2 = (Map.Entry)original.remove(RANDOM.nextInt(original.size()));
            target.put(entry2.getKey(), entry2.getValue());
        }
        return (S)target;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.amountToSample;
    }
}

