/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.WithOptions;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class PropertyMapStep<K, E>
extends MapStep<Element, Map<K, E>>
implements TraversalParent,
ByModulating,
Configuring {
    protected final String[] propertyKeys;
    protected final PropertyType returnType;
    protected int tokens;
    protected Traversal.Admin<Element, ? extends Property> propertyTraversal;
    private Parameters parameters = new Parameters();
    private TraversalRing<K, E> traversalRing;

    @Deprecated
    public PropertyMapStep(Traversal.Admin traversal, boolean includeTokens, PropertyType propertyType, String ... propertyKeys) {
        this(traversal, propertyType, propertyKeys);
        this.configure(WithOptions.tokens, includeTokens ? WithOptions.all : WithOptions.none);
    }

    public PropertyMapStep(Traversal.Admin traversal, PropertyType propertyType, String ... propertyKeys) {
        super(traversal);
        this.propertyKeys = propertyKeys;
        this.returnType = propertyType;
        this.propertyTraversal = null;
        this.traversalRing = new TraversalRing(new Traversal.Admin[0]);
    }

    @Override
    protected Map<K, E> map(Traverser.Admin<Element> traverser) {
        Iterator properties2;
        LinkedHashMap<Object, Object> map2 = new LinkedHashMap<Object, Object>();
        Element element = (Element)traverser.get();
        boolean isVertex = element instanceof Vertex;
        if (this.returnType == PropertyType.VALUE) {
            if (this.includeToken(WithOptions.ids)) {
                map2.put(T.id, element.id());
            }
            if (element instanceof VertexProperty) {
                if (this.includeToken(WithOptions.keys)) {
                    map2.put(T.key, ((VertexProperty)element).key());
                }
                if (this.includeToken(WithOptions.values)) {
                    map2.put(T.value, ((VertexProperty)element).value());
                }
            } else if (this.includeToken(WithOptions.labels)) {
                map2.put(T.label, element.label());
            }
        }
        Iterator iterator2 = properties2 = null == this.propertyTraversal ? element.properties(this.propertyKeys) : TraversalUtil.applyAll(traverser, this.propertyTraversal);
        while (properties2.hasNext()) {
            Property value2;
            Property property = properties2.next();
            Property property2 = value2 = this.returnType == PropertyType.VALUE ? property.value() : property;
            if (isVertex) {
                map2.compute(property.key(), (k, v) -> {
                    List values2 = v != null ? (List)v : new ArrayList();
                    values2.add(value2);
                    return values2;
                });
                continue;
            }
            map2.put(property.key(), value2);
        }
        if (!this.traversalRing.isEmpty()) {
            for (Object key : map2.keySet()) {
                map2.compute(key, (k, v) -> TraversalUtil.applyNullable(v, this.traversalRing.next()));
            }
            this.traversalRing.reset();
        }
        return map2;
    }

    @Override
    public void configure(Object ... keyValues) {
        if (keyValues[0].equals(WithOptions.tokens)) {
            if (keyValues.length == 2 && keyValues[1] instanceof Boolean) {
                this.tokens = (Boolean)keyValues[1] != false ? WithOptions.all : WithOptions.none;
            } else {
                for (int i = 1; i < keyValues.length; ++i) {
                    if (!(keyValues[i] instanceof Integer)) {
                        throw new IllegalArgumentException("WithOptions.tokens requires Integer arguments (possible values are: WithOptions.[none|ids|labels|keys|values|all])");
                    }
                    this.tokens |= ((Integer)keyValues[i]).intValue();
                }
            }
        } else {
            this.parameters.set(this, keyValues);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    public List<Traversal.Admin<K, E>> getLocalChildren() {
        ArrayList<Traversal.Admin<Element, Property<Object>>> result2 = new ArrayList<Traversal.Admin<Element, Property<Object>>>();
        if (null != this.propertyTraversal) {
            result2.add(this.propertyTraversal);
        }
        result2.addAll(this.traversalRing.getTraversals());
        return Collections.unmodifiableList(result2);
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> selectTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(selectTraversal));
    }

    public void setPropertyTraversal(Traversal.Admin<Element, ? extends Property> propertyTraversal) {
        this.propertyTraversal = this.integrateChild(propertyTraversal);
    }

    public PropertyType getReturnType() {
        return this.returnType;
    }

    public String[] getPropertyKeys() {
        return this.propertyKeys;
    }

    @Deprecated
    public boolean isIncludeTokens() {
        return this.tokens != WithOptions.none;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, Arrays.asList(this.propertyKeys), this.traversalRing, this.returnType.name().toLowerCase());
    }

    @Override
    public PropertyMapStep<K, E> clone() {
        PropertyMapStep clone2 = (PropertyMapStep)super.clone();
        if (null != this.propertyTraversal) {
            clone2.propertyTraversal = this.propertyTraversal.clone();
        }
        clone2.traversalRing = this.traversalRing.clone();
        return clone2;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode() ^ this.returnType.hashCode() ^ Integer.hashCode(this.tokens);
        if (null != this.propertyTraversal) {
            result2 ^= this.propertyTraversal.hashCode();
        }
        for (String propertyKey : this.propertyKeys) {
            result2 ^= propertyKey.hashCode();
        }
        return result2 ^ this.traversalRing.hashCode();
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        if (null != this.propertyTraversal) {
            this.integrateChild(this.propertyTraversal);
        }
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }

    public int getIncludedTokens() {
        return this.tokens;
    }

    private boolean includeToken(int token2) {
        return 0 != (this.tokens & token2);
    }
}

