/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MapHelper;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.HashMapSupplier;

public final class GroupCountStep<S, E>
extends ReducingBarrierStep<S, Map<E, Long>>
implements TraversalParent,
ByModulating {
    private Traversal.Admin<S, E> keyTraversal = null;

    public GroupCountStep(Traversal.Admin traversal) {
        super(traversal);
        this.setSeedSupplier(HashMapSupplier.instance());
        this.setReducingBiOperator(GroupCountBiOperator.instance());
    }

    @Override
    public Map<E, Long> projectTraverser(Traverser.Admin<S> traverser) {
        HashMap<E, Long> map2 = new HashMap<E, Long>(1);
        map2.put(TraversalUtil.applyNullable(traverser, this.keyTraversal), traverser.bulk());
        return map2;
    }

    @Override
    public void addLocalChild(Traversal.Admin<?, ?> groupTraversal) {
        this.keyTraversal = this.integrateChild(groupTraversal);
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return null == this.keyTraversal ? Collections.emptyList() : Collections.singletonList(this.keyTraversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.BULK);
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> keyTraversal) throws UnsupportedOperationException {
        this.keyTraversal = this.integrateChild(keyTraversal);
    }

    @Override
    public GroupCountStep<S, E> clone() {
        GroupCountStep clone2 = (GroupCountStep)super.clone();
        if (null != this.keyTraversal) {
            clone2.keyTraversal = this.keyTraversal.clone();
        }
        return clone2;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.keyTraversal);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        if (this.keyTraversal != null) {
            result2 ^= this.keyTraversal.hashCode();
        }
        return result2;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.keyTraversal);
    }

    public static final class GroupCountBiOperator<E>
    implements BinaryOperator<Map<E, Long>>,
    Serializable {
        private static final GroupCountBiOperator INSTANCE = new GroupCountBiOperator();

        @Override
        public Map<E, Long> apply(Map<E, Long> mutatingSeed, Map<E, Long> map2) {
            for (Map.Entry<E, Long> entry2 : map2.entrySet()) {
                MapHelper.incr(mutatingSeed, entry2.getKey(), entry2.getValue());
            }
            return mutatingSeed;
        }

        public static final <E> GroupCountBiOperator<E> instance() {
            return INSTANCE;
        }
    }
}

