/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GraphComputing;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class ElementMapStep<K, E>
extends MapStep<Element, Map<K, E>>
implements TraversalParent,
GraphComputing {
    protected final String[] propertyKeys;
    private boolean onGraphComputer = false;

    public ElementMapStep(Traversal.Admin traversal, String ... propertyKeys) {
        super(traversal);
        this.propertyKeys = propertyKeys;
    }

    @Override
    protected Map<K, E> map(Traverser.Admin<Element> traverser) {
        LinkedHashMap<Object, Object> map2 = new LinkedHashMap<Object, Object>();
        Element element = (Element)traverser.get();
        map2.put(T.id, element.id());
        if (element instanceof VertexProperty) {
            map2.put(T.key, ((VertexProperty)element).key());
            map2.put(T.value, ((VertexProperty)element).value());
        } else {
            map2.put(T.label, element.label());
        }
        if (element instanceof Edge) {
            Edge e = (Edge)element;
            map2.put((Object)Direction.IN, this.getVertexStructure(e.inVertex()));
            map2.put((Object)Direction.OUT, this.getVertexStructure(e.outVertex()));
        }
        Iterator properties2 = element.properties(this.propertyKeys);
        while (properties2.hasNext()) {
            Property property = properties2.next();
            map2.put(property.key(), property.value());
        }
        return map2;
    }

    protected Map<Object, Object> getVertexStructure(Vertex v) {
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        m.put(T.id, v.id());
        if (!this.onGraphComputer) {
            m.put(T.label, v.label());
        }
        return m;
    }

    @Override
    public void onGraphComputer() {
        this.onGraphComputer = true;
    }

    public boolean isOnGraphComputer() {
        return this.onGraphComputer;
    }

    public String[] getPropertyKeys() {
        return this.propertyKeys;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, Arrays.asList(this.propertyKeys));
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        for (String propertyKey : this.propertyKeys) {
            result2 ^= propertyKey.hashCode();
        }
        return result2;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }
}

