/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;

public final class CoalesceStep<S, E>
extends FlatMapStep<S, E>
implements TraversalParent {
    private List<Traversal.Admin<S, E>> coalesceTraversals;

    @SafeVarargs
    public CoalesceStep(Traversal.Admin traversal, Traversal.Admin<S, E> ... coalesceTraversals) {
        super(traversal);
        this.coalesceTraversals = Arrays.asList(coalesceTraversals);
        for (Traversal.Admin<S, E> conjunctionTraversal : this.coalesceTraversals) {
            this.integrateChild(conjunctionTraversal);
        }
    }

    @Override
    protected Iterator<E> flatMap(Traverser.Admin<S> traverser) {
        Traverser.Admin innerTraverser = traverser.clone().asAdmin();
        innerTraverser.setBulk(1L);
        for (Traversal.Admin admin : this.coalesceTraversals) {
            admin.reset();
            admin.addStart(innerTraverser.split());
            if (!admin.hasNext()) continue;
            return admin;
        }
        return EmptyIterator.instance();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return Collections.unmodifiableList(this.coalesceTraversals);
    }

    @Override
    public CoalesceStep<S, E> clone() {
        CoalesceStep clone2 = (CoalesceStep)super.clone();
        clone2.coalesceTraversals = new ArrayList<Traversal.Admin<S, E>>();
        for (Traversal.Admin<S, E> conjunctionTraversal : this.coalesceTraversals) {
            clone2.coalesceTraversals.add(conjunctionTraversal.clone());
        }
        return clone2;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        for (Traversal.Admin<S, E> conjunctionTraversal : this.coalesceTraversals) {
            this.integrateChild(conjunctionTraversal);
        }
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.coalesceTraversals);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        int i = 0;
        for (Traversal.Admin<S, E> traversal : this.coalesceTraversals) {
            result2 ^= Integer.rotateLeft(traversal.hashCode(), i++);
        }
        return result2;
    }
}

