/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class WherePredicateStep<S>
extends FilterStep<S>
implements Scoping,
PathProcessor,
ByModulating,
TraversalParent {
    protected String startKey;
    protected List<String> selectKeys;
    protected P<Object> predicate;
    protected final Set<String> scopeKeys = new HashSet<String>();
    protected Set<String> keepLabels;
    protected TraversalRing<S, ?> traversalRing = new TraversalRing(new Traversal.Admin[0]);

    public WherePredicateStep(Traversal.Admin traversal, Optional<String> startKey, P<String> predicate) {
        super(traversal);
        this.startKey = startKey.orElse(null);
        if (null != this.startKey) {
            this.scopeKeys.add(this.startKey);
        }
        this.predicate = predicate;
        this.selectKeys = new ArrayList<String>();
        this.configurePredicates(this.predicate);
    }

    private void configurePredicates(P<Object> predicate) {
        if (predicate instanceof ConnectiveP) {
            ((ConnectiveP)predicate).getPredicates().forEach(this::configurePredicates);
        } else {
            String selectKey = (String)(predicate.getValue() instanceof Collection ? ((Collection)predicate.getValue()).iterator().next() : predicate.getValue());
            this.selectKeys.add(selectKey);
            this.scopeKeys.add(selectKey);
        }
    }

    private void setPredicateValues(P<Object> predicate, Traverser.Admin<S> traverser, Iterator<String> selectKeysIterator) {
        if (predicate instanceof ConnectiveP) {
            ((ConnectiveP)predicate).getPredicates().forEach(p -> this.setPredicateValues((P<Object>)p, traverser, selectKeysIterator));
        } else {
            predicate.setValue(TraversalUtil.applyNullable(this.getScopeValue(Pop.last, selectKeysIterator.next(), traverser), this.traversalRing.next()));
        }
    }

    public Optional<P<?>> getPredicate() {
        return Optional.ofNullable(this.predicate);
    }

    public Optional<String> getStartKey() {
        return Optional.ofNullable(this.startKey);
    }

    public void removeStartKey() {
        this.selectKeys.remove(this.startKey);
        this.startKey = null;
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        Object value2 = null == this.startKey ? TraversalUtil.applyNullable(traverser, this.traversalRing.next()) : TraversalUtil.applyNullable(this.getScopeValue(Pop.last, this.startKey, traverser), this.traversalRing.next());
        this.setPredicateValues(this.predicate, traverser, this.selectKeys.iterator());
        this.traversalRing.reset();
        return this.predicate.test(value2);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.startKey, this.predicate, this.traversalRing);
    }

    @Override
    public Set<String> getScopeKeys() {
        return Collections.unmodifiableSet(this.scopeKeys);
    }

    @Override
    public WherePredicateStep<S> clone() {
        WherePredicateStep clone2 = (WherePredicateStep)super.clone();
        clone2.predicate = this.predicate.clone();
        clone2.traversalRing = this.traversalRing.clone();
        return clone2;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.traversalRing.hashCode() ^ (null == this.startKey ? "null".hashCode() : this.startKey.hashCode()) ^ this.predicate.hashCode();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.SIDE_EFFECTS);
    }

    public List<Traversal.Admin<S, ?>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    @Override
    protected Traverser.Admin<S> processNextStart() {
        return PathProcessor.processTraverserPathLabels(super.processNextStart(), this.keepLabels);
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> traversal) throws UnsupportedOperationException {
        this.traversalRing.addTraversal(this.integrateChild(traversal));
    }
}

