/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class TimeLimitStep<S>
extends FilterStep<S> {
    private AtomicLong startTime = new AtomicLong(-1L);
    private final long timeLimit;
    private AtomicBoolean timedOut = new AtomicBoolean(false);

    public TimeLimitStep(Traversal.Admin traversal, long timeLimit) {
        super(traversal);
        this.timeLimit = timeLimit;
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        if (this.startTime.get() == -1L) {
            this.startTime.set(System.currentTimeMillis());
        }
        if (System.currentTimeMillis() - this.startTime.get() >= this.timeLimit) {
            this.timedOut.set(true);
            throw FastNoSuchElementException.instance();
        }
        return true;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.timeLimit);
    }

    @Override
    public void reset() {
        super.reset();
        this.startTime.set(-1L);
        this.timedOut.set(false);
    }

    public boolean getTimedOut() {
        return this.timedOut.get();
    }

    @Override
    public TimeLimitStep<S> clone() {
        TimeLimitStep clone2 = (TimeLimitStep)super.clone();
        clone2.timedOut = new AtomicBoolean(this.timedOut.get());
        clone2.startTime = new AtomicLong(this.startTime.get());
        return clone2;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Long.hashCode(this.timeLimit);
    }
}

