/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.CollectingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.ProjectedTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class SampleGlobalStep<S>
extends CollectingBarrierStep<S>
implements TraversalParent,
ByModulating {
    private Traversal.Admin<S, Number> probabilityTraversal = new ConstantTraversal(1.0);
    private final int amountToSample;
    private static final Random RANDOM = new Random();

    public SampleGlobalStep(Traversal.Admin traversal, int amountToSample) {
        super(traversal);
        this.amountToSample = amountToSample;
    }

    public List<Traversal.Admin<S, Number>> getLocalChildren() {
        return Collections.singletonList(this.probabilityTraversal);
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> probabilityTraversal) {
        this.probabilityTraversal = this.integrateChild(probabilityTraversal);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.amountToSample, this.probabilityTraversal);
    }

    @Override
    public void processAllStarts() {
        while (this.starts.hasNext()) {
            this.traverserSet.add(this.createProjectedTraverser((Traverser.Admin<S>)this.starts.next()));
        }
    }

    @Override
    public void barrierConsumer(TraverserSet<S> traverserSet) {
        if (traverserSet.bulkSize() <= (long)this.amountToSample) {
            return;
        }
        double totalWeight = 0.0;
        for (Traverser.Admin<S> s2 : traverserSet) {
            totalWeight += ((Number)((ProjectedTraverser)s2).getProjections().get(0)).doubleValue() * (double)s2.bulk();
        }
        TraverserSet<S> sampledSet = new TraverserSet<S>();
        int runningAmountToSample = 0;
        block1: while (runningAmountToSample < this.amountToSample) {
            boolean reSample = false;
            double runningWeight = 0.0;
            for (Traverser.Admin<S> s3 : traverserSet) {
                long sampleBulk = sampledSet.contains(s3) ? sampledSet.get(s3).bulk() : 0L;
                if (sampleBulk >= s3.bulk()) continue;
                double currentWeight = ((Number)((ProjectedTraverser)s3).getProjections().get(0)).doubleValue();
                int i = 0;
                while ((long)i < s3.bulk() - sampleBulk) {
                    runningWeight += currentWeight;
                    if (RANDOM.nextDouble() <= runningWeight / totalWeight) {
                        Traverser.Admin<S> split2 = s3.split();
                        split2.setBulk(1L);
                        sampledSet.add(split2);
                        ++runningAmountToSample;
                        totalWeight -= currentWeight;
                        reSample = true;
                        break;
                    }
                    ++i;
                }
                if (!reSample && runningAmountToSample < this.amountToSample) continue;
                continue block1;
            }
        }
        traverserSet.clear();
        traverserSet.addAll(sampledSet);
    }

    private final ProjectedTraverser<S, Number> createProjectedTraverser(Traverser.Admin<S> traverser) {
        return new ProjectedTraverser<S, Number>(traverser, Collections.singletonList(TraversalUtil.apply(traverser, this.probabilityTraversal)));
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.BULK);
    }

    @Override
    public SampleGlobalStep<S> clone() {
        SampleGlobalStep clone2 = (SampleGlobalStep)super.clone();
        clone2.probabilityTraversal = this.probabilityTraversal.clone();
        return clone2;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.probabilityTraversal);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.amountToSample ^ this.probabilityTraversal.hashCode();
    }
}

