/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.FromToModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class PathFilterStep<S>
extends FilterStep<S>
implements FromToModulating,
ByModulating,
TraversalParent,
PathProcessor {
    protected String fromLabel;
    protected String toLabel;
    private boolean isSimple;
    private TraversalRing<Object, Object> traversalRing = new TraversalRing(new Traversal.Admin[0]);
    private Set<String> keepLabels;

    public PathFilterStep(Traversal.Admin traversal, boolean isSimple) {
        super(traversal);
        this.isSimple = isSimple;
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        Path path = traverser.path().subPath(this.fromLabel, this.toLabel);
        if (this.traversalRing.isEmpty()) {
            return path.isSimple() == this.isSimple;
        }
        this.traversalRing.reset();
        Path byPath = MutablePath.make();
        path.forEach((object, labels) -> byPath.extend(TraversalUtil.applyNullable(object, this.traversalRing.next()), (Set<String>)labels));
        return byPath.isSimple() == this.isSimple;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.PATH);
    }

    @Override
    public void addFrom(String fromLabel) {
        this.fromLabel = fromLabel;
    }

    @Override
    public void addTo(String toLabel) {
        this.toLabel = toLabel;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.isSimple ? "simple" : "cyclic", this.fromLabel, this.toLabel, this.traversalRing);
    }

    @Override
    public PathFilterStep<S> clone() {
        PathFilterStep clone2 = (PathFilterStep)super.clone();
        clone2.traversalRing = this.traversalRing.clone();
        return clone2;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    public List<Traversal.Admin<Object, Object>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> pathTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(pathTraversal));
    }

    @Override
    public void reset() {
        super.reset();
        this.traversalRing.reset();
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.traversalRing.hashCode() ^ Boolean.hashCode(this.isSimple) ^ (null == this.fromLabel ? "null".hashCode() : this.fromLabel.hashCode()) ^ (null == this.toLabel ? "null".hashCode() : this.toLabel.hashCode());
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
    }

    @Override
    protected Traverser.Admin<S> processNextStart() {
        return PathProcessor.processTraverserPathLabels(super.processNextStart(), this.keepLabels);
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }
}

