/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.GraphComputing;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;

public final class DedupGlobalStep<S>
extends FilterStep<S>
implements TraversalParent,
Scoping,
GraphComputing,
Barrier<Map<Object, Traverser.Admin<S>>>,
ByModulating,
PathProcessor {
    private Traversal.Admin<S, Object> dedupTraversal = null;
    private Set<Object> duplicateSet = new HashSet<Object>();
    private boolean onGraphComputer = false;
    private final Set<String> dedupLabels;
    private Set<String> keepLabels;
    private boolean executingAtMaster = false;
    private Map<Object, Traverser.Admin<S>> barrier;
    private Iterator<Map.Entry<Object, Traverser.Admin<S>>> barrierIterator;

    public DedupGlobalStep(Traversal.Admin traversal, String ... dedupLabels) {
        super(traversal);
        this.dedupLabels = dedupLabels.length == 0 ? null : Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(dedupLabels)));
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        if (this.onGraphComputer && !this.executingAtMaster) {
            return true;
        }
        traverser.setBulk(1L);
        if (null == this.dedupLabels) {
            return this.duplicateSet.add(TraversalUtil.applyNullable(traverser, this.dedupTraversal));
        }
        ArrayList objects = new ArrayList(this.dedupLabels.size());
        this.dedupLabels.forEach(label -> objects.add(TraversalUtil.applyNullable(this.getScopeValue(Pop.last, (String)label, traverser), this.dedupTraversal)));
        return this.duplicateSet.add(objects);
    }

    @Override
    public void atMaster(boolean atMaster) {
        this.executingAtMaster = atMaster;
    }

    @Override
    public PathProcessor.ElementRequirement getMaxRequirement() {
        return null == this.dedupLabels ? PathProcessor.ElementRequirement.ID : PathProcessor.super.getMaxRequirement();
    }

    @Override
    protected Traverser.Admin<S> processNextStart() {
        if (null != this.barrier) {
            this.barrierIterator = this.barrier.entrySet().iterator();
            this.barrier = null;
        }
        while (this.barrierIterator != null && this.barrierIterator.hasNext()) {
            Map.Entry<Object, Traverser.Admin<S>> entry2;
            if (null == this.barrierIterator) {
                this.barrierIterator = this.barrier.entrySet().iterator();
            }
            if (!this.duplicateSet.add((entry2 = this.barrierIterator.next()).getKey())) continue;
            return PathProcessor.processTraverserPathLabels(entry2.getValue(), this.keepLabels);
        }
        return PathProcessor.processTraverserPathLabels(super.processNextStart(), this.keepLabels);
    }

    public List<Traversal<S, Object>> getLocalChildren() {
        return null == this.dedupTraversal ? Collections.emptyList() : Collections.singletonList(this.dedupTraversal);
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> dedupTraversal) {
        this.dedupTraversal = this.integrateChild(dedupTraversal);
    }

    @Override
    public DedupGlobalStep<S> clone() {
        DedupGlobalStep clone2 = (DedupGlobalStep)super.clone();
        clone2.duplicateSet = new HashSet<Object>();
        if (null != this.dedupTraversal) {
            clone2.dedupTraversal = this.dedupTraversal.clone();
        }
        return clone2;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.dedupTraversal);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        if (this.dedupTraversal != null) {
            result2 ^= this.dedupTraversal.hashCode();
        }
        if (this.dedupLabels != null) {
            result2 ^= this.dedupLabels.hashCode();
        }
        return result2;
    }

    @Override
    public void reset() {
        super.reset();
        this.duplicateSet.clear();
        this.barrier = null;
        this.barrierIterator = null;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.dedupLabels, this.dedupTraversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.dedupLabels == null ? this.getSelfAndChildRequirements(TraverserRequirement.BULK) : this.getSelfAndChildRequirements(TraverserRequirement.LABELED_PATH, TraverserRequirement.BULK);
    }

    @Override
    public void onGraphComputer() {
        this.onGraphComputer = true;
    }

    @Override
    public Set<String> getScopeKeys() {
        return null == this.dedupLabels ? Collections.emptySet() : this.dedupLabels;
    }

    @Override
    public void processAllStarts() {
    }

    @Override
    public boolean hasNextBarrier() {
        return null != this.barrier || this.starts.hasNext();
    }

    @Override
    public Map<Object, Traverser.Admin<S>> nextBarrier() throws NoSuchElementException {
        HashMap<Object, Traverser.Admin<S>> map2;
        HashMap<Object, Traverser.Admin<S>> hashMap = map2 = null != this.barrier ? this.barrier : new HashMap<Object, Traverser.Admin<S>>();
        while (this.starts.hasNext()) {
            ArrayList object;
            Object traverser = this.starts.next();
            if (null != this.dedupLabels) {
                object = new ArrayList(this.dedupLabels.size());
                for (String label : this.dedupLabels) {
                    ((List)object).add(TraversalUtil.applyNullable(this.getScopeValue(Pop.last, label, (Traverser.Admin<?>)traverser), this.dedupTraversal));
                }
            } else {
                object = TraversalUtil.applyNullable(traverser, this.dedupTraversal);
            }
            if (map2.containsKey(object)) continue;
            traverser.setBulk(1L);
            traverser.set(DetachedFactory.detach(traverser.get(), true));
            map2.put(object, (Traverser.Admin<S>)traverser);
        }
        this.barrier = null;
        this.barrierIterator = null;
        if (map2.isEmpty()) {
            throw FastNoSuchElementException.instance();
        }
        return map2;
    }

    @Override
    public void addBarrier(Map<Object, Traverser.Admin<S>> barrier) {
        if (null == this.barrier) {
            this.barrier = new HashMap<Object, Traverser.Admin<S>>(barrier);
        } else {
            this.barrier.putAll(barrier);
        }
    }

    @Override
    public MemoryComputeKey<Map<Object, Traverser.Admin<S>>> getMemoryComputeKey() {
        return MemoryComputeKey.of(this.getId(), Operator.addAll, false, true);
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }
}

