/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.OptionsStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SackStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SideEffectStrategy;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.ConstantSupplier;

public interface TraversalSource
extends Cloneable,
AutoCloseable {
    public TraversalStrategies getStrategies();

    public Graph getGraph();

    public Bytecode getBytecode();

    default public TraversalSource with(String key) {
        return this.with(key, true);
    }

    default public TraversalSource with(String key, Object value2) {
        OptionsStrategy.Builder builder = OptionsStrategy.build();
        this.getStrategies().getStrategy(OptionsStrategy.class).ifPresent(optionsStrategy -> optionsStrategy.getOptions().forEach(builder::with));
        builder.with(key, value2);
        return this.withStrategies(builder.create());
    }

    default public TraversalSource withStrategies(TraversalStrategy ... traversalStrategies) {
        TraversalSource clone2 = this.clone();
        clone2.getStrategies().addStrategies(traversalStrategies);
        clone2.getBytecode().addSource("withStrategies", traversalStrategies);
        for (TraversalStrategy traversalStrategy : traversalStrategies) {
            if (!(traversalStrategy instanceof VertexProgramStrategy)) continue;
            ((VertexProgramStrategy)traversalStrategy).addGraphComputerStrategies(clone2);
        }
        return clone2;
    }

    default public TraversalSource withoutStrategies(Class<? extends TraversalStrategy> ... traversalStrategyClasses) {
        TraversalSource clone2 = this.clone();
        clone2.getStrategies().removeStrategies(traversalStrategyClasses);
        clone2.getBytecode().addSource("withoutStrategies", traversalStrategyClasses);
        return clone2;
    }

    default public TraversalSource withComputer(Computer computer) {
        return this.withStrategies(new VertexProgramStrategy(computer));
    }

    default public TraversalSource withComputer(Class<? extends GraphComputer> graphComputerClass) {
        return this.withStrategies(new VertexProgramStrategy(Computer.compute(graphComputerClass)));
    }

    default public TraversalSource withComputer() {
        return this.withStrategies(new VertexProgramStrategy(Computer.compute()));
    }

    default public <A> TraversalSource withSideEffect(String key, Supplier<A> initialValue, BinaryOperator<A> reducer) {
        TraversalSource clone2 = this.clone();
        SideEffectStrategy.addSideEffect(clone2.getStrategies(), key, initialValue, reducer);
        clone2.getBytecode().addSource("withSideEffect", key, initialValue, reducer);
        return clone2;
    }

    default public <A> TraversalSource withSideEffect(String key, A initialValue, BinaryOperator<A> reducer) {
        TraversalSource clone2 = this.clone();
        SideEffectStrategy.addSideEffect(clone2.getStrategies(), key, initialValue, reducer);
        clone2.getBytecode().addSource("withSideEffect", key, initialValue, reducer);
        return clone2;
    }

    default public <A> TraversalSource withSideEffect(String key, Supplier<A> initialValue) {
        TraversalSource clone2 = this.clone();
        SideEffectStrategy.addSideEffect(clone2.getStrategies(), key, initialValue, null);
        clone2.getBytecode().addSource("withSideEffect", key, initialValue);
        return clone2;
    }

    default public <A> TraversalSource withSideEffect(String key, A initialValue) {
        TraversalSource clone2 = this.clone();
        SideEffectStrategy.addSideEffect(clone2.getStrategies(), key, initialValue, null);
        clone2.getBytecode().addSource("withSideEffect", key, initialValue);
        return clone2;
    }

    default public <A> TraversalSource withSack(Supplier<A> initialValue, UnaryOperator<A> splitOperator, BinaryOperator<A> mergeOperator) {
        TraversalSource clone2 = this.clone();
        clone2.getStrategies().addStrategies(SackStrategy.build().initialValue(initialValue).splitOperator(splitOperator).mergeOperator(mergeOperator).create());
        clone2.getBytecode().addSource("withSack", initialValue, splitOperator, mergeOperator);
        return clone2;
    }

    default public <A> TraversalSource withSack(A initialValue, UnaryOperator<A> splitOperator, BinaryOperator<A> mergeOperator) {
        TraversalSource clone2 = this.clone();
        clone2.getStrategies().addStrategies(SackStrategy.build().initialValue(new ConstantSupplier<A>(initialValue)).splitOperator(splitOperator).mergeOperator(mergeOperator).create());
        clone2.getBytecode().addSource("withSack", initialValue, splitOperator, mergeOperator);
        return clone2;
    }

    default public <A> TraversalSource withSack(A initialValue) {
        TraversalSource clone2 = this.clone();
        clone2.getStrategies().addStrategies(SackStrategy.build().initialValue(new ConstantSupplier<A>(initialValue)).create());
        clone2.getBytecode().addSource("withSack", initialValue);
        return clone2;
    }

    default public <A> TraversalSource withSack(Supplier<A> initialValue) {
        TraversalSource clone2 = this.clone();
        clone2.getStrategies().addStrategies(SackStrategy.build().initialValue(initialValue).create());
        clone2.getBytecode().addSource("withSack", initialValue);
        return clone2;
    }

    default public <A> TraversalSource withSack(Supplier<A> initialValue, UnaryOperator<A> splitOperator) {
        TraversalSource clone2 = this.clone();
        clone2.getStrategies().addStrategies(SackStrategy.build().initialValue(initialValue).splitOperator(splitOperator).create());
        clone2.getBytecode().addSource("withSack", initialValue, splitOperator);
        return clone2;
    }

    default public <A> TraversalSource withSack(A initialValue, UnaryOperator<A> splitOperator) {
        TraversalSource clone2 = this.clone();
        clone2.getStrategies().addStrategies(SackStrategy.build().initialValue(new ConstantSupplier<A>(initialValue)).splitOperator(splitOperator).create());
        clone2.getBytecode().addSource("withSack", initialValue, splitOperator);
        return clone2;
    }

    default public <A> TraversalSource withSack(Supplier<A> initialValue, BinaryOperator<A> mergeOperator) {
        TraversalSource clone2 = this.clone();
        clone2.getStrategies().addStrategies(SackStrategy.build().initialValue(initialValue).mergeOperator(mergeOperator).create());
        clone2.getBytecode().addSource("withSack", initialValue, mergeOperator);
        return clone2;
    }

    default public <A> TraversalSource withSack(A initialValue, BinaryOperator<A> mergeOperator) {
        TraversalSource clone2 = this.clone();
        clone2.getStrategies().addStrategies(SackStrategy.build().initialValue(new ConstantSupplier<A>(initialValue)).mergeOperator(mergeOperator).create());
        clone2.getBytecode().addSource("withSack", initialValue, mergeOperator);
        return clone2;
    }

    @Deprecated
    default public TraversalSource withRemote(Configuration conf) {
        RemoteConnection remoteConnection;
        if (!conf.containsKey("gremlin.remote.remoteConnectionClass")) {
            throw new IllegalArgumentException("Configuration must contain the 'gremlin.remote.remoteConnectionClass' key");
        }
        try {
            Class<RemoteConnection> clazz2 = Class.forName(conf.getString("gremlin.remote.remoteConnectionClass")).asSubclass(RemoteConnection.class);
            Constructor<RemoteConnection> ctor = clazz2.getConstructor(Configuration.class);
            remoteConnection = ctor.newInstance(conf);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return this.withRemote(remoteConnection);
    }

    @Deprecated
    default public TraversalSource withRemote(String configFile) throws Exception {
        return this.withRemote(new PropertiesConfiguration(configFile));
    }

    @Deprecated
    public TraversalSource withRemote(RemoteConnection var1);

    default public Optional<Class> getAnonymousTraversalClass() {
        return Optional.empty();
    }

    public TraversalSource clone();

    @Override
    default public void close() throws Exception {
    }

    public static class Symbols {
        public static final String with = "with";
        public static final String withSack = "withSack";
        public static final String withStrategies = "withStrategies";
        public static final String withoutStrategies = "withoutStrategies";
        public static final String withComputer = "withComputer";
        public static final String withSideEffect = "withSideEffect";
        public static final String withRemote = "withRemote";

        private Symbols() {
        }
    }
}

