/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.remote.traversal.step.map.RemoteStep;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NoneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectCapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalExplanation;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public interface Traversal<S, E>
extends Iterator<E>,
Serializable,
Cloneable,
AutoCloseable {
    default public Admin<S, E> asAdmin() {
        return (Admin)this;
    }

    default public Optional<E> tryNext() {
        return this.hasNext() ? Optional.of(this.next()) : Optional.empty();
    }

    default public List<E> next(int amount) {
        ArrayList result2 = new ArrayList();
        int counter = 0;
        while (counter++ < amount && this.hasNext()) {
            result2.add(this.next());
        }
        return result2;
    }

    default public List<E> toList() {
        return this.fill(new ArrayList());
    }

    default public Set<E> toSet() {
        return this.fill(new HashSet());
    }

    default public BulkSet<E> toBulkSet() {
        return this.fill(new BulkSet());
    }

    default public Stream<E> toStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 1088), false);
    }

    default public <T> CompletableFuture<T> promise(Function<Traversal<S, E>, T> traversalFunction) {
        Step<?, E> endStep;
        if (!this.asAdmin().isLocked()) {
            this.asAdmin().applyStrategies();
        }
        if ((endStep = this.asAdmin().getEndStep()) instanceof RemoteStep) {
            return ((RemoteStep)endStep).promise().thenApply(traversalFunction);
        }
        throw new IllegalStateException("Only traversals created using withRemote() can be used in an async way");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <C extends Collection<E>> C fill(C collection2) {
        try {
            try {
                if (!this.asAdmin().isLocked()) {
                    this.asAdmin().applyStrategies();
                }
                Step<?, E> endStep = this.asAdmin().getEndStep();
                while (true) {
                    Traverser traverser = (Traverser)endStep.next();
                    TraversalHelper.addToCollection(collection2, traverser.get(), traverser.bulk());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                CloseableIterator.closeIterator(this);
            }
        }
        catch (Throwable throwable2) {
            CloseableIterator.closeIterator(this);
            throw throwable2;
        }
        return collection2;
    }

    default public <A, B> Traversal<A, B> iterate() {
        try {
            try {
                if (!this.asAdmin().isLocked()) {
                    this.none();
                    this.asAdmin().applyStrategies();
                }
                Step<?, E> endStep = this.asAdmin().getEndStep();
                while (true) {
                    endStep.next();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                CloseableIterator.closeIterator(this);
            }
        }
        catch (Throwable throwable2) {
            CloseableIterator.closeIterator(this);
            throw throwable2;
        }
        return this;
    }

    default public Traversal<S, E> none() {
        this.asAdmin().getBytecode().addStep("none", new Object[0]);
        return this.asAdmin().addStep(new NoneStep(this.asAdmin()));
    }

    default public Traversal<S, TraversalMetrics> profile() {
        this.asAdmin().getBytecode().addStep("profile", new Object[0]);
        return this.asAdmin().addStep(new ProfileSideEffectStep(this.asAdmin(), ProfileSideEffectStep.DEFAULT_METRICS_KEY)).addStep(new SideEffectCapStep(this.asAdmin(), ProfileSideEffectStep.DEFAULT_METRICS_KEY, new String[0]));
    }

    default public TraversalExplanation explain() {
        if (this.asAdmin().isLocked()) {
            throw new IllegalStateException("The traversal is locked and can not be explained on a strategy-by-strategy basis");
        }
        return new TraversalExplanation(this.asAdmin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E2> void forEachRemaining(Class<E2> endType, Consumer<E2> consumer) {
        try {
            try {
                while (true) {
                    consumer.accept(this.next());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                CloseableIterator.closeIterator(this);
            }
        }
        catch (Throwable throwable2) {
            CloseableIterator.closeIterator(this);
            throw throwable2;
        }
    }

    @Override
    default public void forEachRemaining(Consumer<? super E> action2) {
        try {
            try {
                while (true) {
                    action2.accept(this.next());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                CloseableIterator.closeIterator(this);
            }
        }
        catch (Throwable throwable2) {
            CloseableIterator.closeIterator(this);
            throw throwable2;
        }
    }

    @Override
    default public void close() throws Exception {
        for (Step step : this.asAdmin().getSteps()) {
            if (!(step instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)step)).close();
        }
    }

    public static interface Admin<S, E>
    extends Traversal<S, E> {
        public Bytecode getBytecode();

        default public void addStarts(Iterator<Traverser.Admin<S>> starts2) {
            if (!this.isLocked()) {
                this.applyStrategies();
            }
            this.getStartStep().addStarts(starts2);
        }

        default public void addStart(Traverser.Admin<S> start) {
            if (!this.isLocked()) {
                this.applyStrategies();
            }
            this.getStartStep().addStart(start);
        }

        public List<Step> getSteps();

        default public <E2> Admin<S, E2> addStep(Step<?, E2> step) throws IllegalStateException {
            return this.addStep(this.getSteps().size(), step);
        }

        public <S2, E2> Admin<S2, E2> addStep(int var1, Step<?, ?> var2) throws IllegalStateException;

        default public <S2, E2> Admin<S2, E2> removeStep(Step<?, ?> step) throws IllegalStateException {
            return this.removeStep(TraversalHelper.stepIndex(step, this));
        }

        public <S2, E2> Admin<S2, E2> removeStep(int var1) throws IllegalStateException;

        default public Step<S, ?> getStartStep() {
            List<Step> steps = this.getSteps();
            return steps.isEmpty() ? EmptyStep.instance() : steps.get(0);
        }

        default public Step<?, E> getEndStep() {
            List<Step> steps = this.getSteps();
            return steps.isEmpty() ? EmptyStep.instance() : steps.get(steps.size() - 1);
        }

        public void applyStrategies() throws IllegalStateException;

        public TraverserGenerator getTraverserGenerator();

        public Set<TraverserRequirement> getTraverserRequirements();

        default public void reset() {
            this.getSteps().forEach(Step::reset);
        }

        public void setSideEffects(TraversalSideEffects var1);

        public TraversalSideEffects getSideEffects();

        public void setStrategies(TraversalStrategies var1);

        public TraversalStrategies getStrategies();

        public void setParent(TraversalParent var1);

        public TraversalParent getParent();

        public Admin<S, E> clone();

        public boolean isLocked();

        public Optional<Graph> getGraph();

        default public Optional<TraversalSource> getTraversalSource() {
            return Optional.empty();
        }

        public void setGraph(Graph var1);

        default public boolean equals(Admin<S, E> other) {
            if (this.getClass().equals(other.getClass())) {
                List<Step> steps = this.getSteps();
                List<Step> otherSteps = other.getSteps();
                if (steps.size() == otherSteps.size()) {
                    for (int i = 0; i < steps.size(); ++i) {
                        if (steps.get(i).equals(otherSteps.get(i))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        default public Traverser.Admin<E> nextTraverser() {
            return (Traverser.Admin)this.getEndStep().next();
        }
    }

    public static class Exceptions {
        public static IllegalStateException traversalIsLocked() {
            return new IllegalStateException("The traversal strategies are complete and the traversal can no longer be modulated");
        }

        public static IllegalStateException traversalIsNotReversible() {
            return new IllegalStateException("The traversal is not reversible as it contains steps that are not reversible");
        }
    }

    public static class Symbols {
        public static final String profile = "profile";
        public static final String none = "none";

        private Symbols() {
        }
    }
}

