/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.javatuples.Pair;

public interface Path
extends Cloneable,
Iterable<Object> {
    default public int size() {
        return this.objects().size();
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public <A> A head() {
        return (A)this.objects().get(this.size() - 1);
    }

    public Path extend(Object var1, Set<String> var2);

    public Path extend(Set<String> var1);

    public Path retract(Set<String> var1);

    default public <A> A get(String label) throws IllegalArgumentException {
        List<Object> objects = this.objects();
        List<Set<String>> labels = this.labels();
        ArrayList<Object> object = null;
        for (int i = 0; i < labels.size(); ++i) {
            if (!labels.get(i).contains(label)) continue;
            if (null == object) {
                object = objects.get(i);
                continue;
            }
            if (object instanceof List) {
                ((List)object).add(objects.get(i));
                continue;
            }
            ArrayList<Object> list2 = new ArrayList<Object>(2);
            list2.add(object);
            list2.add(objects.get(i));
            object = list2;
        }
        if (null == object) {
            throw Exceptions.stepWithProvidedLabelDoesNotExist(label);
        }
        return (A)object;
    }

    default public <A> A get(Pop pop, String label) throws IllegalArgumentException {
        if (Pop.mixed == pop) {
            return this.get(label);
        }
        if (Pop.all == pop) {
            if (this.hasLabel(label)) {
                A object = this.get(label);
                if (object instanceof List) {
                    return object;
                }
                return (A)Collections.singletonList(object);
            }
            return (A)Collections.emptyList();
        }
        A object = this.get(label);
        if (object instanceof List) {
            return (A)(Pop.last == pop ? ((List)object).get(((List)object).size() - 1) : ((List)object).get(0));
        }
        return object;
    }

    default public <A> A get(int index2) {
        return (A)this.objects().get(index2);
    }

    default public boolean hasLabel(String label) {
        return this.labels().stream().filter(labels -> labels.contains(label)).findAny().isPresent();
    }

    public List<Object> objects();

    public List<Set<String>> labels();

    public Path clone();

    default public boolean isSimple() {
        List<Object> objects = this.objects();
        for (int i = 0; i < objects.size() - 1; ++i) {
            for (int j = i + 1; j < objects.size(); ++j) {
                if (!objects.get(i).equals(objects.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    default public Iterator<Object> iterator() {
        return this.objects().iterator();
    }

    default public void forEach(BiConsumer<Object, Set<String>> consumer) {
        List<Object> objects = this.objects();
        List<Set<String>> labels = this.labels();
        for (int i = 0; i < objects.size(); ++i) {
            consumer.accept(objects.get(i), labels.get(i));
        }
    }

    default public Stream<Pair<Object, Set<String>>> stream() {
        List<Set<String>> labels = this.labels();
        List<Object> objects = this.objects();
        return IntStream.range(0, this.size()).mapToObj(i -> Pair.with(objects.get(i), labels.get(i)));
    }

    default public boolean popEquals(Pop pop, Object other) {
        if (!(other instanceof Path)) {
            return false;
        }
        Path otherPath = (Path)other;
        return !this.labels().stream().flatMap(Collection::stream).filter(label -> !otherPath.hasLabel((String)label) || !otherPath.get(pop, (String)label).equals(this.get(pop, (String)label))).findAny().isPresent();
    }

    default public Path subPath(String fromLabel, String toLabel) {
        Set<String> labels;
        int i;
        if (null == fromLabel && null == toLabel) {
            return this;
        }
        Path subPath = MutablePath.make();
        int size2 = this.size();
        int fromIndex = -1;
        int toIndex = -1;
        for (i = size2 - 1; i >= 0; --i) {
            labels = this.labels().get(i);
            if (-1 == fromIndex && labels.contains(fromLabel)) {
                fromIndex = i;
            }
            if (-1 != toIndex || !labels.contains(toLabel)) continue;
            toIndex = i;
        }
        if (null != fromLabel && -1 == fromIndex) {
            throw Exceptions.couldNotLocatePathFromLabel(fromLabel);
        }
        if (null != toLabel && -1 == toIndex) {
            throw Exceptions.couldNotLocatePathToLabel(toLabel);
        }
        if (fromIndex == -1) {
            fromIndex = 0;
        }
        if (toIndex == -1) {
            toIndex = size2 - 1;
        }
        if (fromIndex > toIndex) {
            throw Exceptions.couldNotIsolatedSubPath(fromLabel, toLabel);
        }
        for (i = fromIndex; i <= toIndex; ++i) {
            labels = this.labels().get(i);
            subPath.extend(this.get(i), labels);
        }
        return subPath;
    }

    public static class Exceptions {
        public static IllegalArgumentException stepWithProvidedLabelDoesNotExist(String label) {
            return new IllegalArgumentException("The step with label " + label + " does not exist");
        }

        public static IllegalArgumentException couldNotLocatePathFromLabel(String fromLabel) {
            return new IllegalArgumentException("Could not locate path from-label: " + fromLabel);
        }

        public static IllegalArgumentException couldNotLocatePathToLabel(String toLabel) {
            return new IllegalArgumentException("Could not locate path to-label: " + toLabel);
        }

        public static IllegalArgumentException couldNotIsolatedSubPath(String fromLabel, String toLabel) {
            return new IllegalArgumentException("Could not isolate path because from comes after to: " + fromLabel + "->" + toLabel);
        }
    }
}

