/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;

public class P<V>
implements Predicate<V>,
Serializable,
Cloneable {
    protected BiPredicate<V, V> biPredicate;
    protected V value;
    protected V originalValue;

    public P(BiPredicate<V, V> biPredicate, V value2) {
        this.value = value2;
        this.originalValue = value2;
        this.biPredicate = biPredicate;
    }

    public BiPredicate<V, V> getBiPredicate() {
        return this.biPredicate;
    }

    public V getOriginalValue() {
        return this.originalValue;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value2) {
        this.value = value2;
    }

    @Override
    public boolean test(V testValue) {
        return this.biPredicate.test(testValue, this.value);
    }

    public int hashCode() {
        int result2 = this.biPredicate.hashCode();
        if (null != this.originalValue) {
            result2 ^= this.originalValue.hashCode();
        }
        return result2;
    }

    public boolean equals(Object other) {
        return other instanceof P && ((P)other).getClass().equals(this.getClass()) && ((P)other).getBiPredicate().equals(this.biPredicate) && (((P)other).getOriginalValue() == null && this.originalValue == null || ((P)other).getOriginalValue().equals(this.originalValue));
    }

    public String toString() {
        return null == this.originalValue ? this.biPredicate.toString() : this.biPredicate.toString() + "(" + this.originalValue + ")";
    }

    @Override
    public P<V> negate() {
        return new P<V>(this.biPredicate.negate(), this.originalValue);
    }

    @Override
    public P<V> and(Predicate<? super V> predicate) {
        if (!(predicate instanceof P)) {
            throw new IllegalArgumentException("Only P predicates can be and'd together");
        }
        return new AndP(Arrays.asList(this, (P)predicate));
    }

    @Override
    public P<V> or(Predicate<? super V> predicate) {
        if (!(predicate instanceof P)) {
            throw new IllegalArgumentException("Only P predicates can be or'd together");
        }
        return new OrP(Arrays.asList(this, (P)predicate));
    }

    public P<V> clone() {
        try {
            return (P)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <V> P<V> eq(V value2) {
        return new P<Object>(Compare.eq, value2);
    }

    public static <V> P<V> neq(V value2) {
        return new P<Object>(Compare.neq, value2);
    }

    public static <V> P<V> lt(V value2) {
        return new P<Object>(Compare.lt, value2);
    }

    public static <V> P<V> lte(V value2) {
        return new P<Object>(Compare.lte, value2);
    }

    public static <V> P<V> gt(V value2) {
        return new P<Object>(Compare.gt, value2);
    }

    public static <V> P<V> gte(V value2) {
        return new P<Object>(Compare.gte, value2);
    }

    public static <V> P<V> inside(V first, V second) {
        return new AndP(Arrays.asList(new P<Object>(Compare.gt, first), new P<Object>(Compare.lt, second)));
    }

    public static <V> P<V> outside(V first, V second) {
        return new OrP(Arrays.asList(new P<Object>(Compare.lt, first), new P<Object>(Compare.gt, second)));
    }

    public static <V> P<V> between(V first, V second) {
        return new AndP(Arrays.asList(new P<Object>(Compare.gte, first), new P<Object>(Compare.lt, second)));
    }

    public static <V> P<V> within(V ... values2) {
        return P.within(Arrays.asList(values2));
    }

    public static <V> P<V> within(Collection<V> value2) {
        return new P<Collection<V>>(Contains.within, value2);
    }

    public static <V> P<V> without(V ... values2) {
        return P.without(Arrays.asList(values2));
    }

    public static <V> P<V> without(Collection<V> value2) {
        return new P<Collection<V>>(Contains.without, value2);
    }

    public static P test(BiPredicate biPredicate, Object value2) {
        return new P<Object>(biPredicate, value2);
    }

    public static <V> P<V> not(P<V> predicate) {
        return predicate.negate();
    }
}

