/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Bindings;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class Bytecode
implements Cloneable,
Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private List<Instruction> sourceInstructions = new ArrayList<Instruction>();
    private List<Instruction> stepInstructions = new ArrayList<Instruction>();

    public void addSource(String sourceName, Object ... arguments) {
        if (sourceName.equals("withoutStrategies")) {
            if (arguments == null) {
                this.sourceInstructions.add(new Instruction(sourceName, null));
            } else {
                Object[] classes2 = new Class[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    classes2[i] = arguments[i] instanceof TraversalStrategyProxy ? ((TraversalStrategyProxy)arguments[i]).getStrategyClass() : (Class)arguments[i];
                }
                this.sourceInstructions.add(new Instruction(sourceName, classes2));
            }
        } else {
            this.sourceInstructions.add(new Instruction(sourceName, this.flattenArguments(arguments)));
        }
        Bindings.clear();
    }

    public void addStep(String stepName, Object ... arguments) {
        this.stepInstructions.add(new Instruction(stepName, this.flattenArguments(arguments)));
        Bindings.clear();
    }

    public List<Instruction> getSourceInstructions() {
        return this.sourceInstructions;
    }

    public List<Instruction> getStepInstructions() {
        return this.stepInstructions;
    }

    public Iterable<Instruction> getInstructions() {
        return () -> IteratorUtils.concat(this.sourceInstructions.iterator(), this.stepInstructions.iterator());
    }

    public Map<String, Object> getBindings() {
        HashMap<String, Object> bindingsMap = new HashMap<String, Object>();
        for (Instruction instruction : this.sourceInstructions) {
            for (Object argument2 : instruction.getArguments()) {
                Bytecode.addArgumentBinding(bindingsMap, argument2);
            }
        }
        for (Instruction instruction : this.stepInstructions) {
            for (Object argument2 : instruction.getArguments()) {
                Bytecode.addArgumentBinding(bindingsMap, argument2);
            }
        }
        return bindingsMap;
    }

    private static final void addArgumentBinding(Map<String, Object> bindingsMap, Object argument2) {
        if (argument2 instanceof Binding) {
            bindingsMap.put(((Binding)argument2).key, ((Binding)argument2).value);
        } else if (argument2 instanceof Map) {
            for (Map.Entry entry2 : ((Map)argument2).entrySet()) {
                Bytecode.addArgumentBinding(bindingsMap, entry2.getKey());
                Bytecode.addArgumentBinding(bindingsMap, entry2.getValue());
            }
        } else if (argument2 instanceof Collection) {
            for (Object item : (Collection)argument2) {
                Bytecode.addArgumentBinding(bindingsMap, item);
            }
        } else if (argument2 instanceof Bytecode) {
            bindingsMap.putAll(((Bytecode)argument2).getBindings());
        }
    }

    public String toString() {
        return Arrays.asList(this.sourceInstructions, this.stepInstructions).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bytecode bytecode = (Bytecode)o;
        return Objects.equals(this.sourceInstructions, bytecode.sourceInstructions) && Objects.equals(this.stepInstructions, bytecode.stepInstructions);
    }

    public int hashCode() {
        return Objects.hash(this.sourceInstructions, this.stepInstructions);
    }

    public Bytecode clone() {
        try {
            Bytecode clone2 = (Bytecode)super.clone();
            clone2.sourceInstructions = new ArrayList<Instruction>(this.sourceInstructions);
            clone2.stepInstructions = new ArrayList<Instruction>(this.stepInstructions);
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private final Object[] flattenArguments(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> flatArguments = new ArrayList<Object>(arguments.length);
        for (Object object : arguments) {
            if (object instanceof Object[]) {
                for (Object nestObject : (Object[])object) {
                    flatArguments.add(this.convertArgument(nestObject, true));
                }
                continue;
            }
            flatArguments.add(this.convertArgument(object, true));
        }
        return flatArguments.toArray();
    }

    private final Object convertArgument(Object argument2, boolean searchBindings) {
        String variable2;
        if (searchBindings && null != (variable2 = Bindings.getBoundVariable(argument2))) {
            return new Binding<Object>(variable2, this.convertArgument(argument2, false));
        }
        if (argument2 instanceof Traversal) {
            return ((Traversal)argument2).asAdmin().getBytecode();
        }
        if (argument2 instanceof Map) {
            LinkedHashMap<Object, Object> map2 = new LinkedHashMap<Object, Object>(((Map)argument2).size());
            for (Map.Entry entry2 : ((Map)argument2).entrySet()) {
                map2.put(this.convertArgument(entry2.getKey(), true), this.convertArgument(entry2.getValue(), true));
            }
            return map2;
        }
        if (argument2 instanceof List) {
            ArrayList<Object> list2 = new ArrayList<Object>(((List)argument2).size());
            for (Object item : (List)argument2) {
                list2.add(this.convertArgument(item, true));
            }
            return list2;
        }
        if (argument2 instanceof Set) {
            LinkedHashSet<Object> set2 = new LinkedHashSet<Object>(((Set)argument2).size());
            for (Object item : (Set)argument2) {
                set2.add(this.convertArgument(item, true));
            }
            return set2;
        }
        return argument2;
    }

    public static class Binding<V>
    implements Serializable {
        private final String key;
        private final V value;

        public Binding(String key, V value2) {
            this.key = key;
            this.value = value2;
        }

        public String variable() {
            return this.key;
        }

        public V value() {
            return this.value;
        }

        public String toString() {
            return "binding[" + this.key + "=" + this.value + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Binding binding = (Binding)o;
            return Objects.equals(this.key, binding.key) && Objects.equals(this.value, binding.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }

    public static class Instruction
    implements Serializable {
        private final String operator;
        private final Object[] arguments;

        private Instruction(String operator, Object ... arguments) {
            this.operator = operator;
            this.arguments = arguments;
        }

        public String getOperator() {
            return this.operator;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public String toString() {
            return this.operator + "(" + StringFactory.removeEndBrackets(Arrays.asList(this.arguments)) + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Instruction that = (Instruction)o;
            return Objects.equals(this.operator, that.operator) && Arrays.equals(this.arguments, that.arguments);
        }

        public int hashCode() {
            int result2 = Objects.hash(this.operator);
            result2 = 31 * result2 + Arrays.hashCode(this.arguments);
            return result2;
        }
    }
}

