/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal.step.map;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.traversal.MemoryTraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TraversalVertexProgramStep
extends VertexProgramStep
implements TraversalParent {
    public PureTraversal<?, ?> computerTraversal;

    public TraversalVertexProgramStep(Traversal.Admin traversal, Traversal.Admin<?, ?> computerTraversal) {
        super(traversal);
        this.computerTraversal = new PureTraversal(computerTraversal);
        this.integrateChild(this.computerTraversal.get());
    }

    public List<Traversal.Admin<?, ?>> getGlobalChildren() {
        return Collections.singletonList(this.computerTraversal.get());
    }

    public void setComputerTraversal(Traversal.Admin<?, ?> computerTraversal) {
        this.computerTraversal = new PureTraversal(computerTraversal);
        this.integrateChild(this.computerTraversal.get());
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.computerTraversal.get(), new GraphFilter(this.computer));
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return TraversalParent.super.getSelfAndChildRequirements(TraverserRequirement.BULK);
    }

    @Override
    public TraversalVertexProgram generateProgram(Graph graph, Memory memory) {
        Traversal.Admin<?, ?> computerSpecificTraversal = this.computerTraversal.getPure();
        TraversalStrategies computerSpecificStrategies = this.getTraversal().getStrategies().clone();
        IteratorUtils.filter(TraversalStrategies.GlobalCache.getStrategies(graph.getClass()).toList(), s2 -> s2 instanceof TraversalStrategy.ProviderOptimizationStrategy).forEach(xva$0 -> computerSpecificStrategies.addStrategies((TraversalStrategy<?>)xva$0));
        computerSpecificTraversal.setStrategies(computerSpecificStrategies);
        computerSpecificTraversal.setSideEffects(new MemoryTraversalSideEffects(this.getTraversal().getSideEffects()));
        computerSpecificTraversal.setParent(this);
        TraversalVertexProgram.Builder builder = TraversalVertexProgram.build().traversal(computerSpecificTraversal);
        if (memory.exists("gremlin.traversalVertexProgram.haltedTraversers")) {
            builder.haltedTraversers((TraverserSet)memory.get("gremlin.traversalVertexProgram.haltedTraversers"));
        }
        return (TraversalVertexProgram)builder.create(graph);
    }

    @Override
    public TraversalVertexProgramStep clone() {
        TraversalVertexProgramStep clone2 = (TraversalVertexProgramStep)super.clone();
        clone2.computerTraversal = this.computerTraversal.clone();
        return clone2;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.computerTraversal.get());
    }
}

