/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.Bypassing;
import org.apache.tinkerpop.gremlin.process.traversal.step.GraphComputing;
import org.apache.tinkerpop.gremlin.process.traversal.step.LocalBarrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.HaltedTraverserStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.IndexedTraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMatrix;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

final class WorkerExecutor {
    private WorkerExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean execute(Vertex vertex, Messenger<TraverserSet<Object>> messenger, TraversalMatrix<?, ?> traversalMatrix, Memory memory, boolean returnHaltedTraversers, TraverserSet<Object> haltedTraversers, HaltedTraverserStrategy haltedTraverserStrategy) {
        Traverser.Admin<Object> traverser2;
        IndexedTraverserSet maybeActiveTraversers;
        TraversalSideEffects traversalSideEffects = traversalMatrix.getTraversal().getSideEffects();
        AtomicBoolean voteToHalt = new AtomicBoolean(true);
        TraverserSet<Object> activeTraversers = new TraverserSet<Object>();
        TraverserSet<Object> toProcessTraversers = new TraverserSet<Object>();
        IndexedTraverserSet indexedTraverserSet = maybeActiveTraversers = (IndexedTraverserSet)memory.get("gremlin.traversalVertexProgram.activeTraversers");
        synchronized (indexedTraverserSet) {
            Collection traversers;
            if (!maybeActiveTraversers.isEmpty() && (traversers = maybeActiveTraversers.get(vertex)) != null) {
                Iterator iterator2 = traversers.iterator();
                while (iterator2.hasNext()) {
                    traverser2 = iterator2.next();
                    iterator2.remove();
                    maybeActiveTraversers.remove(traverser2);
                    traverser2.attach(Attachable.Method.get(vertex));
                    traverser2.setSideEffects(traversalSideEffects);
                    toProcessTraversers.add(traverser2);
                }
            }
        }
        vertex.property("gremlin.traversalVertexProgram.activeTraversers").ifPresent(previousActiveTraversers -> {
            IteratorUtils.removeOnNext(previousActiveTraversers.iterator()).forEachRemaining(traverser -> {
                traverser.attach(Attachable.Method.get(vertex));
                traverser.setSideEffects(traversalSideEffects);
                toProcessTraversers.add((Traverser.Admin<Object>)traverser);
            });
            assert (previousActiveTraversers.isEmpty());
            vertex.property("gremlin.traversalVertexProgram.activeTraversers").remove();
        });
        Iterator<TraverserSet<Object>> messages = messenger.receiveMessages();
        while (messages.hasNext()) {
            IteratorUtils.removeOnNext(messages.next().iterator()).forEachRemaining(traverser -> {
                if (traverser.isHalted()) {
                    if (returnHaltedTraversers) {
                        memory.add("gremlin.traversalVertexProgram.haltedTraversers", new TraverserSet(haltedTraverserStrategy.halt(traverser)));
                    } else {
                        haltedTraversers.add((Traverser.Admin<Object>)traverser);
                    }
                } else {
                    traverser.attach(Attachable.Method.get(vertex));
                    traverser.setSideEffects(traversalSideEffects);
                    toProcessTraversers.add((Traverser.Admin<Object>)traverser);
                }
            });
        }
        while (!toProcessTraversers.isEmpty()) {
            EmptyStep<Object, Object> previousStep = EmptyStep.instance();
            Iterator<Traverser.Admin<Object>> traversers = toProcessTraversers.iterator();
            while (traversers.hasNext()) {
                traverser2 = traversers.next();
                traversers.remove();
                Object currentStep = traversalMatrix.getStepById(traverser2.getStepId());
                if (!currentStep.getId().equals(previousStep.getId()) && !(previousStep instanceof EmptyStep)) {
                    WorkerExecutor.drainStep(vertex, previousStep, activeTraversers, haltedTraversers, memory, returnHaltedTraversers, haltedTraverserStrategy);
                }
                currentStep.addStart(traverser2);
                previousStep = currentStep;
            }
            WorkerExecutor.drainStep(vertex, previousStep, activeTraversers, haltedTraversers, memory, returnHaltedTraversers, haltedTraverserStrategy);
            assert (toProcessTraversers.isEmpty());
            if (activeTraversers.isEmpty()) continue;
            traversers = activeTraversers.iterator();
            while (traversers.hasNext()) {
                traverser2 = traversers.next();
                traversers.remove();
                if (traverser2.get() instanceof Element || traverser2.get() instanceof Property) {
                    Vertex hostingVertex = Host.getHostingVertex(traverser2.get());
                    if (!vertex.equals(hostingVertex)) {
                        voteToHalt.set(false);
                        messenger.sendMessage(MessageScope.Global.of(hostingVertex), new TraverserSet<Object>(traverser2.detach()));
                        continue;
                    }
                    traverser2.attach(Attachable.Method.get(vertex));
                    toProcessTraversers.add(traverser2);
                    continue;
                }
                toProcessTraversers.add(traverser2);
            }
            assert (activeTraversers.isEmpty());
        }
        return voteToHalt.get();
    }

    private static void drainStep(Vertex vertex, Step<Object, Object> step, TraverserSet<Object> activeTraversers, TraverserSet<Object> haltedTraversers, Memory memory, boolean returnHaltedTraversers, HaltedTraverserStrategy haltedTraverserStrategy) {
        GraphComputing.atMaster(step, false);
        if (step instanceof Barrier) {
            if (step instanceof Bypassing) {
                ((Bypassing)((Object)step)).setBypass(true);
            }
            if (step instanceof LocalBarrier) {
                LocalBarrier barrier = (LocalBarrier)((Object)step);
                TraverserSet localBarrierTraversers = vertex.property("gremlin.traversalVertexProgram.activeTraversers").orElse(new TraverserSet());
                vertex.property("gremlin.traversalVertexProgram.activeTraversers", localBarrierTraversers);
                while (barrier.hasNextBarrier()) {
                    TraverserSet barrierSet = (TraverserSet)barrier.nextBarrier();
                    IteratorUtils.removeOnNext(barrierSet.iterator()).forEachRemaining(traverser -> {
                        traverser.addLabels(step.getLabels());
                        if (traverser.isHalted() && (returnHaltedTraversers || !(traverser.get() instanceof Element) && !(traverser.get() instanceof Property) || Host.getHostingVertex(traverser.get()).equals(vertex))) {
                            if (returnHaltedTraversers) {
                                memory.add("gremlin.traversalVertexProgram.haltedTraversers", new TraverserSet(haltedTraverserStrategy.halt(traverser)));
                            } else {
                                haltedTraversers.add(traverser.detach());
                            }
                        } else {
                            localBarrierTraversers.add(traverser.detach());
                        }
                    });
                }
                memory.add("gremlin.traversalVertexProgram.mutatedMemoryKeys", new HashSet<String>(Collections.singleton(step.getId())));
            } else {
                Barrier barrier = (Barrier)((Object)step);
                while (barrier.hasNextBarrier()) {
                    memory.add(step.getId(), barrier.nextBarrier());
                }
                memory.add("gremlin.traversalVertexProgram.mutatedMemoryKeys", new HashSet<String>(Collections.singleton(step.getId())));
            }
        } else {
            step.forEachRemaining(traverser -> {
                if (traverser.isHalted() && ((returnHaltedTraversers || ReferenceFactory.class == haltedTraverserStrategy.getHaltedTraverserFactory()) && !(traverser.get() instanceof Element) && !(traverser.get() instanceof Property) || Host.getHostingVertex(traverser.get()).equals(vertex))) {
                    if (returnHaltedTraversers) {
                        memory.add("gremlin.traversalVertexProgram.haltedTraversers", new TraverserSet(haltedTraverserStrategy.halt(traverser)));
                    } else {
                        haltedTraversers.add(traverser.detach());
                    }
                } else {
                    activeTraversers.add((Traverser.Admin<Object>)traverser);
                }
            });
        }
    }
}

