/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.GraphComputing;
import org.apache.tinkerpop.gremlin.process.traversal.step.LocalBarrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TailGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IdStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LabelStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyKeyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SackStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.HaltedTraverserStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMatrix;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;

final class MasterExecutor {
    private MasterExecutor() {
    }

    protected static void processMemory(TraversalMatrix<?, ?> traversalMatrix, Memory memory, TraverserSet<Object> toProcessTraversers, Set<String> completedBarriers) {
        if (memory.exists("gremlin.traversalVertexProgram.mutatedMemoryKeys")) {
            for (String key : (Set)memory.get("gremlin.traversalVertexProgram.mutatedMemoryKeys")) {
                Object step = traversalMatrix.getStepById(key);
                assert (step instanceof Barrier);
                completedBarriers.add(step.getId());
                if (step instanceof LocalBarrier) continue;
                Barrier barrier = (Barrier)step;
                barrier.addBarrier(memory.get(key));
                step.forEachRemaining(toProcessTraversers::add);
                if (!(step instanceof ReducingBarrierStep)) continue;
                memory.set(step.getId(), ((ReducingBarrierStep)step).getSeedSupplier().get());
            }
        }
        memory.set("gremlin.traversalVertexProgram.mutatedMemoryKeys", new HashSet());
    }

    protected static void processTraversers(PureTraversal<?, ?> traversal, TraversalMatrix<?, ?> traversalMatrix, TraverserSet<Object> toProcessTraversers, TraverserSet<Object> remoteActiveTraversers, TraverserSet<Object> haltedTraversers, HaltedTraverserStrategy haltedTraverserStrategy) {
        while (!toProcessTraversers.isEmpty()) {
            Traverser.Admin traverser;
            TraverserSet localActiveTraversers = new TraverserSet();
            EmptyStep previousStep = EmptyStep.instance();
            EmptyStep currentStep = EmptyStep.instance();
            Iterator<Traverser.Admin<Object>> traversers = toProcessTraversers.iterator();
            while (traversers.hasNext()) {
                traverser = traversers.next();
                traversers.remove();
                traverser.set(DetachedFactory.detach(traverser.get(), true));
                traverser.setSideEffects(traversal.get().getSideEffects());
                if (traverser.isHalted()) {
                    haltedTraversers.add(haltedTraverserStrategy.halt(traverser));
                    continue;
                }
                if (MasterExecutor.isRemoteTraverser(traverser, traversalMatrix)) {
                    remoteActiveTraversers.add(traverser.detach());
                    continue;
                }
                currentStep = traversalMatrix.getStepById(traverser.getStepId());
                if (!currentStep.getId().equals(previousStep.getId()) && !(previousStep instanceof EmptyStep)) {
                    GraphComputing.atMaster(previousStep, true);
                    while (previousStep.hasNext()) {
                        Traverser.Admin result2 = (Traverser.Admin)previousStep.next();
                        if (result2.isHalted()) {
                            haltedTraversers.add(haltedTraverserStrategy.halt(result2));
                            continue;
                        }
                        if (MasterExecutor.isRemoteTraverser(result2, traversalMatrix)) {
                            remoteActiveTraversers.add(result2.detach());
                            continue;
                        }
                        localActiveTraversers.add(result2);
                    }
                }
                currentStep.addStart(traverser);
                previousStep = currentStep;
            }
            if (!(currentStep instanceof EmptyStep)) {
                GraphComputing.atMaster(currentStep, true);
                while (currentStep.hasNext()) {
                    traverser = (Traverser.Admin)currentStep.next();
                    if (traverser.isHalted()) {
                        haltedTraversers.add(haltedTraverserStrategy.halt(traverser));
                        continue;
                    }
                    if (MasterExecutor.isRemoteTraverser(traverser, traversalMatrix)) {
                        remoteActiveTraversers.add(traverser.detach());
                        continue;
                    }
                    localActiveTraversers.add(traverser);
                }
            }
            assert (toProcessTraversers.isEmpty());
            toProcessTraversers = localActiveTraversers;
        }
    }

    private static boolean isRemoteTraverser(Traverser.Admin traverser, TraversalMatrix<?, ?> traversalMatrix) {
        return traverser.get() instanceof Attachable && !(traverser.get() instanceof Path) && !MasterExecutor.isLocalElement(traversalMatrix.getStepById(traverser.getStepId()));
    }

    private static boolean isLocalElement(Step<?, ?> step) {
        return step instanceof PropertiesStep || step instanceof PropertyMapStep || step instanceof IdStep || step instanceof LabelStep || step instanceof SackStep || step instanceof PropertyKeyStep || step instanceof PropertyValueStep || step instanceof TailGlobalStep || step instanceof RangeGlobalStep || step instanceof HasStep || step instanceof ConnectiveStep;
    }
}

