/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankMessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.util.AbstractVertexProgramBuilder;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.ScriptTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class PageRankVertexProgram
implements VertexProgram<Double> {
    public static final String PAGE_RANK = "gremlin.pageRankVertexProgram.pageRank";
    private static final String EDGE_COUNT = "gremlin.pageRankVertexProgram.edgeCount";
    private static final String PROPERTY = "gremlin.pageRankVertexProgram.property";
    private static final String VERTEX_COUNT = "gremlin.pageRankVertexProgram.vertexCount";
    private static final String ALPHA = "gremlin.pageRankVertexProgram.alpha";
    private static final String EPSILON = "gremlin.pageRankVertexProgram.epsilon";
    private static final String MAX_ITERATIONS = "gremlin.pageRankVertexProgram.maxIterations";
    private static final String EDGE_TRAVERSAL = "gremlin.pageRankVertexProgram.edgeTraversal";
    private static final String INITIAL_RANK_TRAVERSAL = "gremlin.pageRankVertexProgram.initialRankTraversal";
    private static final String TELEPORTATION_ENERGY = "gremlin.pageRankVertexProgram.teleportationEnergy";
    private static final String CONVERGENCE_ERROR = "gremlin.pageRankVertexProgram.convergenceError";
    private MessageScope.Local<Double> incidentMessageScope = MessageScope.Local.of(() -> __.outE(new String[0]));
    private MessageScope.Local<Double> countMessageScope = MessageScope.Local.of(new MessageScope.Local.ReverseTraversalSupplier(this.incidentMessageScope));
    private PureTraversal<Vertex, Edge> edgeTraversal = null;
    private PureTraversal<Vertex, ? extends Number> initialRankTraversal = null;
    private double alpha = 0.85;
    private double epsilon = 1.0E-5;
    private int maxIterations = 20;
    private String property = "gremlin.pageRankVertexProgram.pageRank";
    private Set<VertexComputeKey> vertexComputeKeys;
    private Set<MemoryComputeKey> memoryComputeKeys;

    private PageRankVertexProgram() {
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        if (configuration.containsKey(INITIAL_RANK_TRAVERSAL)) {
            this.initialRankTraversal = PureTraversal.loadState(configuration, INITIAL_RANK_TRAVERSAL, graph);
        }
        if (configuration.containsKey(EDGE_TRAVERSAL)) {
            this.edgeTraversal = PureTraversal.loadState(configuration, EDGE_TRAVERSAL, graph);
            this.incidentMessageScope = MessageScope.Local.of(() -> this.edgeTraversal.get().clone());
            this.countMessageScope = MessageScope.Local.of(new MessageScope.Local.ReverseTraversalSupplier(this.incidentMessageScope));
        }
        this.alpha = configuration.getDouble(ALPHA, this.alpha);
        this.epsilon = configuration.getDouble(EPSILON, this.epsilon);
        this.maxIterations = configuration.getInt(MAX_ITERATIONS, 20);
        this.property = configuration.getString(PROPERTY, PAGE_RANK);
        this.vertexComputeKeys = new HashSet<VertexComputeKey>(Arrays.asList(VertexComputeKey.of(this.property, false), VertexComputeKey.of(EDGE_COUNT, true)));
        this.memoryComputeKeys = new HashSet<MemoryComputeKey>(Arrays.asList(MemoryComputeKey.of(TELEPORTATION_ENERGY, Operator.sum, true, true), MemoryComputeKey.of(VERTEX_COUNT, Operator.sum, true, true), MemoryComputeKey.of(CONVERGENCE_ERROR, Operator.sum, false, true)));
    }

    @Override
    public void storeState(Configuration configuration) {
        VertexProgram.super.storeState(configuration);
        configuration.setProperty(ALPHA, this.alpha);
        configuration.setProperty(EPSILON, this.epsilon);
        configuration.setProperty(PROPERTY, this.property);
        configuration.setProperty(MAX_ITERATIONS, this.maxIterations);
        if (null != this.edgeTraversal) {
            this.edgeTraversal.storeState(configuration, EDGE_TRAVERSAL);
        }
        if (null != this.initialRankTraversal) {
            this.initialRankTraversal.storeState(configuration, INITIAL_RANK_TRAVERSAL);
        }
    }

    @Override
    public GraphComputer.ResultGraph getPreferredResultGraph() {
        return GraphComputer.ResultGraph.NEW;
    }

    @Override
    public GraphComputer.Persist getPreferredPersist() {
        return GraphComputer.Persist.VERTEX_PROPERTIES;
    }

    @Override
    public Set<VertexComputeKey> getVertexComputeKeys() {
        return this.vertexComputeKeys;
    }

    @Override
    public Optional<MessageCombiner<Double>> getMessageCombiner() {
        return PageRankMessageCombiner.instance();
    }

    @Override
    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return this.memoryComputeKeys;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        HashSet<MessageScope> set2 = new HashSet<MessageScope>();
        set2.add(memory.isInitialIteration() ? this.countMessageScope : this.incidentMessageScope);
        return set2;
    }

    public PageRankVertexProgram clone() {
        try {
            PageRankVertexProgram clone2 = (PageRankVertexProgram)super.clone();
            if (null != this.initialRankTraversal) {
                clone2.initialRankTraversal = this.initialRankTraversal.clone();
            }
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void setup(Memory memory) {
        memory.set(TELEPORTATION_ENERGY, null == this.initialRankTraversal ? 1.0 : 0.0);
        memory.set(VERTEX_COUNT, 0.0);
        memory.set(CONVERGENCE_ERROR, 1.0);
    }

    @Override
    public void execute(Vertex vertex, Messenger<Double> messenger, Memory memory) {
        if (memory.isInitialIteration()) {
            messenger.sendMessage(this.countMessageScope, 1.0);
            memory.add(VERTEX_COUNT, 1.0);
        } else {
            double pageRank;
            double edgeCount;
            double vertexCount = (Double)memory.get(VERTEX_COUNT);
            if (1 == memory.getIteration()) {
                edgeCount = IteratorUtils.reduce(messenger.receiveMessages(), Double.valueOf(0.0), (a, b) -> a + b);
                vertex.property(VertexProperty.Cardinality.single, EDGE_COUNT, edgeCount, new Object[0]);
                pageRank = null == this.initialRankTraversal ? 0.0 : TraversalUtil.apply(vertex, this.initialRankTraversal.get()).doubleValue();
            } else {
                edgeCount = (Double)vertex.value(EDGE_COUNT);
                pageRank = IteratorUtils.reduce(messenger.receiveMessages(), Double.valueOf(0.0), (a, b) -> a + b);
            }
            double teleporationEnergy = (Double)memory.get(TELEPORTATION_ENERGY);
            if (teleporationEnergy > 0.0) {
                double localTerminalEnergy = teleporationEnergy / vertexCount;
                pageRank += localTerminalEnergy;
                memory.add(TELEPORTATION_ENERGY, -localTerminalEnergy);
            }
            double previousPageRank = vertex.property(this.property).orElse(0.0);
            memory.add(CONVERGENCE_ERROR, Math.abs(pageRank - previousPageRank));
            vertex.property(VertexProperty.Cardinality.single, this.property, pageRank, new Object[0]);
            memory.add(TELEPORTATION_ENERGY, (1.0 - this.alpha) * pageRank);
            pageRank = this.alpha * pageRank;
            if (edgeCount > 0.0) {
                messenger.sendMessage(this.incidentMessageScope, pageRank / edgeCount);
            } else {
                memory.add(TELEPORTATION_ENERGY, pageRank);
            }
        }
    }

    @Override
    public boolean terminate(Memory memory) {
        boolean terminate = (Double)memory.get(CONVERGENCE_ERROR) < this.epsilon || memory.getIteration() >= this.maxIterations;
        memory.set(CONVERGENCE_ERROR, 0.0);
        return terminate;
    }

    public String toString() {
        return StringFactory.vertexProgramString(this, "alpha=" + this.alpha + ", epsilon=" + this.epsilon + ", iterations=" + this.maxIterations);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    public VertexProgram.Features getFeatures() {
        return new VertexProgram.Features(){

            @Override
            public boolean requiresLocalMessageScopes() {
                return true;
            }

            @Override
            public boolean requiresVertexPropertyAddition() {
                return true;
            }
        };
    }

    public static final class Builder
    extends AbstractVertexProgramBuilder<Builder> {
        private Builder() {
            super(PageRankVertexProgram.class);
        }

        public Builder iterations(int iterations) {
            this.configuration.setProperty(PageRankVertexProgram.MAX_ITERATIONS, iterations);
            return this;
        }

        public Builder alpha(double alpha) {
            this.configuration.setProperty(PageRankVertexProgram.ALPHA, alpha);
            return this;
        }

        public Builder property(String key) {
            this.configuration.setProperty(PageRankVertexProgram.PROPERTY, key);
            return this;
        }

        public Builder epsilon(double epsilon) {
            this.configuration.setProperty(PageRankVertexProgram.EPSILON, epsilon);
            return this;
        }

        public Builder edges(Traversal.Admin<Vertex, Edge> edgeTraversal) {
            PureTraversal.storeState(this.configuration, PageRankVertexProgram.EDGE_TRAVERSAL, edgeTraversal);
            return this;
        }

        public Builder initialRank(Traversal.Admin<Vertex, ? extends Number> initialRankTraversal) {
            PureTraversal.storeState(this.configuration, PageRankVertexProgram.INITIAL_RANK_TRAVERSAL, initialRankTraversal);
            return this;
        }

        @Deprecated
        public Builder vertexCount(long vertexCount) {
            this.configuration.setProperty(PageRankVertexProgram.VERTEX_COUNT, vertexCount);
            return this;
        }

        @Deprecated
        public Builder traversal(TraversalSource traversalSource, String scriptEngine, String traversalScript, Object ... bindings) {
            return this.edges(new ScriptTraversal<Vertex, Edge>(traversalSource, scriptEngine, traversalScript, bindings));
        }

        @Deprecated
        public Builder traversal(Traversal.Admin<Vertex, Edge> traversal) {
            return this.edges(traversal);
        }
    }
}

