/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.bulkloading;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoader;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.IncrementalBulkLoader;
import org.apache.tinkerpop.gremlin.process.computer.util.AbstractVertexProgramBuilder;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.MutationListener;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.javatuples.Pair;
import org.javatuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BulkLoaderVertexProgram
implements VertexProgram<Tuple> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkLoaderVertexProgram.class);
    public static final String BULK_LOADER_VERTEX_PROGRAM_CFG_PREFIX = "gremlin.bulkLoaderVertexProgram";
    public static final String BULK_LOADER_CLASS_CFG_KEY = String.join((CharSequence)".", "gremlin.bulkLoaderVertexProgram", "class");
    public static final String BULK_LOADER_VERTEX_ID_CFG_KEY = String.join((CharSequence)".", "gremlin.bulkLoaderVertexProgram", "vertexIdProperty");
    public static final String INTERMEDIATE_BATCH_SIZE_CFG_KEY = String.join((CharSequence)".", "gremlin.bulkLoaderVertexProgram", "intermediateBatchSize");
    public static final String KEEP_ORIGINAL_IDS_CFG_KEY = String.join((CharSequence)".", "gremlin.bulkLoaderVertexProgram", "keepOriginalIds");
    public static final String USER_SUPPLIED_IDS_CFG_KEY = String.join((CharSequence)".", "gremlin.bulkLoaderVertexProgram", "userSuppliedIds");
    public static final String WRITE_GRAPH_CFG_KEY = String.join((CharSequence)".", "gremlin.bulkLoaderVertexProgram", "writeGraph");
    public static final String DEFAULT_BULK_LOADER_VERTEX_ID = "bulkLoader.vertex.id";
    private final MessageScope messageScope = MessageScope.Local.of(() -> __.inE(new String[0]));
    private final Set<VertexComputeKey> elementComputeKeys = new HashSet<VertexComputeKey>();
    private Configuration configuration;
    private BulkLoader bulkLoader;
    private Graph graph;
    private GraphTraversalSource g;
    private long intermediateBatchSize;
    private BulkLoadingListener listener;

    private BulkLoaderVertexProgram() {
    }

    private BulkLoader createBulkLoader() {
        BulkLoader loader;
        Configuration config = this.configuration.subset(BULK_LOADER_VERTEX_PROGRAM_CFG_PREFIX);
        if (config.containsKey("class")) {
            String className2 = config.getString("class");
            try {
                Class<?> bulkLoaderClass = Class.forName(className2);
                loader = (BulkLoader)bulkLoaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Unable to find custom bulk loader class: {}", (Object)className2);
                throw new IllegalStateException(e);
            }
            catch (Exception e) {
                LOGGER.error("Unable to create an instance of the given bulk loader class: {}", (Object)className2);
                throw new IllegalStateException(e);
            }
        } else {
            loader = new IncrementalBulkLoader();
        }
        loader.configure(this.configuration);
        return loader;
    }

    private void commit(boolean close2) {
        if (!(close2 || this.intermediateBatchSize != 0L && this.listener.mutations() >= this.intermediateBatchSize)) {
            return;
        }
        if (null != this.graph) {
            if (this.graph.features().graph().supportsTransactions()) {
                LOGGER.info("Committing transaction on Graph instance: {} [{} mutations]", (Object)this.graph, (Object)this.listener.mutations());
                try {
                    this.graph.tx().commit();
                    LOGGER.debug("Committed transaction on Graph instance: {}", (Object)this.graph);
                    this.listener.resetCounter();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to commit transaction on Graph instance: {}", (Object)this.graph);
                    this.graph.tx().rollback();
                    this.listener.resetCounter();
                    throw e;
                }
            }
            if (close2) {
                try {
                    this.graph.close();
                    LOGGER.info("Closed Graph instance: {}", (Object)this.graph);
                    this.graph = null;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to close Graph instance", e);
                }
            }
        }
    }

    @Override
    public void setup(Memory memory) {
    }

    @Override
    public void loadState(Graph graph, Configuration config) {
        this.configuration = new BaseConfiguration();
        if (config != null) {
            ConfigurationUtils.copy(config, this.configuration);
        }
        this.intermediateBatchSize = this.configuration.getLong(INTERMEDIATE_BATCH_SIZE_CFG_KEY, 0L);
        this.elementComputeKeys.add(VertexComputeKey.of(DEFAULT_BULK_LOADER_VERTEX_ID, true));
        this.bulkLoader = this.createBulkLoader();
    }

    @Override
    public void storeState(Configuration config) {
        VertexProgram.super.storeState(config);
        if (this.configuration != null) {
            ConfigurationUtils.copy(this.configuration, config);
        }
    }

    @Override
    public void workerIterationStart(Memory memory) {
        if (null == this.graph) {
            this.graph = GraphFactory.open(this.configuration.subset(WRITE_GRAPH_CFG_KEY));
            LOGGER.info("Opened Graph instance: {}", (Object)this.graph);
            try {
                this.listener = new BulkLoadingListener();
                this.g = this.graph.traversal().withStrategies(EventStrategy.build().addListener(this.listener).create());
            }
            catch (Exception e) {
                try {
                    this.graph.close();
                }
                catch (Exception e2) {
                    LOGGER.warn("Failed to close Graph instance", e2);
                }
                throw e;
            }
        }
        LOGGER.warn("Leaked Graph instance: {}", (Object)this.graph);
    }

    @Override
    public void workerIterationEnd(Memory memory) {
        this.commit(true);
    }

    @Override
    public void execute(Vertex sourceVertex, Messenger<Tuple> messenger, Memory memory) {
        try {
            this.executeInternal(sourceVertex, messenger, memory);
        }
        catch (Exception e) {
            if (this.graph.features().graph().supportsTransactions()) {
                this.graph.tx().rollback();
            }
            throw e;
        }
    }

    private void executeInternal(Vertex sourceVertex, Messenger<Tuple> messenger, Memory memory) {
        if (memory.isInitialIteration()) {
            this.listener.resetStats();
            Vertex targetVertex = this.bulkLoader.getOrCreateVertex(sourceVertex, this.graph, this.g);
            Iterator vpi = sourceVertex.properties(new String[0]);
            if (this.listener.isNewVertex()) {
                vpi.forEachRemaining(vp -> this.bulkLoader.createVertexProperty((VertexProperty<?>)vp, targetVertex, this.graph, this.g));
            } else {
                vpi.forEachRemaining(vp -> this.bulkLoader.getOrCreateVertexProperty((VertexProperty<?>)vp, targetVertex, this.graph, this.g));
            }
            this.commit(false);
            if (!this.bulkLoader.useUserSuppliedIds()) {
                sourceVertex.property(DEFAULT_BULK_LOADER_VERTEX_ID, targetVertex.id());
                messenger.sendMessage(this.messageScope, Pair.with(sourceVertex.id(), targetVertex.id()));
            }
        } else if (memory.getIteration() == 1) {
            if (this.bulkLoader.useUserSuppliedIds()) {
                Vertex outV = this.bulkLoader.getVertex(sourceVertex, this.graph, this.g);
                boolean incremental = outV.edges(Direction.OUT, new String[0]).hasNext();
                sourceVertex.edges(Direction.OUT, new String[0]).forEachRemaining(edge -> {
                    Vertex inV = this.bulkLoader.getVertex(edge.inVertex(), this.graph, this.g);
                    if (incremental) {
                        this.bulkLoader.getOrCreateEdge((Edge)edge, outV, inV, this.graph, this.g);
                    } else {
                        this.bulkLoader.createEdge((Edge)edge, outV, inV, this.graph, this.g);
                    }
                    this.commit(false);
                });
            } else {
                HashMap<Object, Object> idPairs = new HashMap<Object, Object>();
                Iterator<Tuple> idi = messenger.receiveMessages();
                while (idi.hasNext()) {
                    Tuple idPair = idi.next();
                    idPairs.put(idPair.getValue(0), idPair.getValue(1));
                }
                Object outVId = sourceVertex.value(DEFAULT_BULK_LOADER_VERTEX_ID);
                Vertex outV = this.bulkLoader.getVertexById(outVId, this.graph, this.g);
                sourceVertex.edges(Direction.OUT, new String[0]).forEachRemaining(edge -> {
                    Object inVId = idPairs.get(edge.inVertex().id());
                    Vertex inV = this.bulkLoader.getVertexById(inVId, this.graph, this.g);
                    this.bulkLoader.getOrCreateEdge((Edge)edge, outV, inV, this.graph, this.g);
                    this.commit(false);
                });
            }
        } else if (memory.getIteration() == 2) {
            Object vertexId = sourceVertex.value(DEFAULT_BULK_LOADER_VERTEX_ID);
            this.bulkLoader.getVertexById(vertexId, this.graph, this.g).property(this.bulkLoader.getVertexIdProperty()).remove();
            this.commit(false);
        }
    }

    @Override
    public boolean terminate(Memory memory) {
        switch (memory.getIteration()) {
            case 1: {
                return this.bulkLoader.keepOriginalIds() || this.bulkLoader.getVertexIdProperty() == null;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<VertexComputeKey> getVertexComputeKeys() {
        return this.elementComputeKeys;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        return Collections.singleton(this.messageScope);
    }

    @Override
    public VertexProgram<Tuple> clone() {
        return this;
    }

    @Override
    public GraphComputer.ResultGraph getPreferredResultGraph() {
        return GraphComputer.ResultGraph.ORIGINAL;
    }

    @Override
    public GraphComputer.Persist getPreferredPersist() {
        return GraphComputer.Persist.NOTHING;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.bulkLoader != null) {
            sb.append("bulkLoader=").append(this.bulkLoader.getClass().getSimpleName()).append(", ");
            sb.append("vertexIdProperty=").append(this.bulkLoader.getVertexIdProperty()).append(", ");
            sb.append("userSuppliedIds=").append(this.bulkLoader.useUserSuppliedIds()).append(", ");
            sb.append("keepOriginalIds=").append(this.bulkLoader.keepOriginalIds()).append(", ");
        } else {
            sb.append("bulkLoader=").append(this.bulkLoader).append(", ");
        }
        sb.append("batchSize=").append(this.intermediateBatchSize);
        return StringFactory.vertexProgramString(this, sb.toString());
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    public VertexProgram.Features getFeatures() {
        return new VertexProgram.Features(){

            @Override
            public boolean requiresLocalMessageScopes() {
                return true;
            }

            @Override
            public boolean requiresVertexPropertyAddition() {
                return true;
            }
        };
    }

    static class BulkLoadingListener
    implements MutationListener {
        private long counter = 0L;
        private boolean isNewVertex = false;

        public boolean isNewVertex() {
            return this.isNewVertex;
        }

        public long mutations() {
            return this.counter;
        }

        public void resetStats() {
            this.isNewVertex = false;
        }

        public void resetCounter() {
            this.counter = 0L;
        }

        @Override
        public void vertexAdded(Vertex vertex) {
            this.isNewVertex = true;
            ++this.counter;
        }

        @Override
        public void vertexRemoved(Vertex vertex) {
            ++this.counter;
        }

        @Override
        public void vertexPropertyChanged(Vertex element, VertexProperty oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
            ++this.counter;
        }

        @Override
        public void vertexPropertyRemoved(VertexProperty vertexProperty) {
            ++this.counter;
        }

        @Override
        public void edgeAdded(Edge edge) {
            ++this.counter;
        }

        @Override
        public void edgeRemoved(Edge edge) {
            ++this.counter;
        }

        @Override
        public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
            ++this.counter;
        }

        @Override
        public void edgePropertyRemoved(Edge element, Property property) {
            ++this.counter;
        }

        @Override
        public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
            ++this.counter;
        }

        @Override
        public void vertexPropertyPropertyRemoved(VertexProperty element, Property property) {
            ++this.counter;
        }
    }

    public static class Builder
    extends AbstractVertexProgramBuilder<Builder> {
        private Builder() {
            super(BulkLoaderVertexProgram.class);
        }

        @Override
        public BulkLoaderVertexProgram create(Graph graph) {
            ConfigurationUtils.append(graph.configuration().subset(BulkLoaderVertexProgram.BULK_LOADER_VERTEX_PROGRAM_CFG_PREFIX), this.configuration);
            return (BulkLoaderVertexProgram)VertexProgram.createVertexProgram(graph, this.configuration);
        }

        private void setGraphConfigurationProperty(String key, Object value2) {
            this.configuration.setProperty(String.join((CharSequence)".", WRITE_GRAPH_CFG_KEY, key), value2);
        }

        public Builder bulkLoader(String className2) {
            this.configuration.setProperty(BULK_LOADER_CLASS_CFG_KEY, className2);
            return this;
        }

        public Builder bulkLoader(Class<? extends BulkLoader> clazz2) {
            return this.bulkLoader(clazz2.getCanonicalName());
        }

        public Builder vertexIdProperty(String name2) {
            this.configuration.setProperty(BULK_LOADER_VERTEX_ID_CFG_KEY, name2);
            return this;
        }

        public Builder userSuppliedIds(boolean useUserSuppliedIds) {
            this.configuration.setProperty(USER_SUPPLIED_IDS_CFG_KEY, useUserSuppliedIds);
            return this;
        }

        public Builder keepOriginalIds(boolean keepOriginalIds) {
            this.configuration.setProperty(KEEP_ORIGINAL_IDS_CFG_KEY, keepOriginalIds);
            return this;
        }

        public Builder intermediateBatchSize(int batchSize) {
            this.configuration.setProperty(INTERMEDIATE_BATCH_SIZE_CFG_KEY, batchSize);
            return this;
        }

        public Builder writeGraph(String configurationFile) throws ConfigurationException {
            return this.writeGraph(new PropertiesConfiguration(configurationFile));
        }

        public Builder writeGraph(Configuration configuration) {
            configuration.getKeys().forEachRemaining(key -> this.setGraphConfigurationProperty((String)key, configuration.getProperty((String)key)));
            return this;
        }
    }
}

