/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public interface MapReduce<MK, MV, RK, RV, R>
extends Cloneable {
    public static final String MAP_REDUCE = "gremlin.mapReduce";

    default public void storeState(Configuration configuration) {
        configuration.setProperty(MAP_REDUCE, this.getClass().getName());
    }

    default public void loadState(Graph graph, Configuration configuration) {
    }

    public boolean doStage(Stage var1);

    public void map(Vertex var1, MapEmitter<MK, MV> var2);

    default public void combine(MK key, Iterator<MV> values2, ReduceEmitter<RK, RV> emitter) {
    }

    default public void reduce(MK key, Iterator<MV> values2, ReduceEmitter<RK, RV> emitter) {
    }

    default public void workerStart(Stage stage) {
    }

    default public void workerEnd(Stage stage) {
    }

    default public Optional<Comparator<MK>> getMapKeySort() {
        return Optional.empty();
    }

    default public Optional<Comparator<RK>> getReduceKeySort() {
        return Optional.empty();
    }

    public R generateFinalResult(Iterator<KeyValue<RK, RV>> var1);

    public String getMemoryKey();

    default public void addResultToMemory(Memory.Admin memory, Iterator<KeyValue<RK, RV>> keyValues) {
        memory.set(this.getMemoryKey(), this.generateFinalResult(keyValues));
    }

    public MapReduce<MK, MV, RK, RV, R> clone();

    public static <M extends MapReduce> M createMapReduce(Graph graph, Configuration configuration) {
        try {
            Class<?> mapReduceClass = Class.forName(configuration.getString(MAP_REDUCE));
            Constructor<?> constructor = mapReduceClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            MapReduce mapReduce = (MapReduce)constructor.newInstance(new Object[0]);
            mapReduce.loadState(graph, configuration);
            return (M)mapReduce;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static class NullObject
    implements Comparable<NullObject>,
    Serializable {
        private static final NullObject INSTANCE = new NullObject();
        private static final String NULL_OBJECT = "";

        public static NullObject instance() {
            return INSTANCE;
        }

        public int hashCode() {
            return -9832049;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof NullObject;
        }

        @Override
        public int compareTo(NullObject object) {
            return 0;
        }

        public String toString() {
            return NULL_OBJECT;
        }
    }

    public static interface ReduceEmitter<OK, OV> {
        public void emit(OK var1, OV var2);

        default public void emit(OV value2) {
            this.emit(NullObject.instance(), value2);
        }
    }

    public static interface MapEmitter<K, V> {
        public void emit(K var1, V var2);

        default public void emit(V value2) {
            this.emit(NullObject.instance(), value2);
        }
    }

    public static enum Stage {
        MAP,
        COMBINE,
        REDUCE;

    }
}

