/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public final class Computer
implements Function<Graph, GraphComputer>,
Serializable,
Cloneable {
    private Class<? extends GraphComputer> graphComputerClass = GraphComputer.class;
    private Map<String, Object> configuration = new HashMap<String, Object>();
    private int workers = -1;
    private GraphComputer.Persist persist = null;
    private GraphComputer.ResultGraph resultGraph = null;
    private Traversal<Vertex, Vertex> vertices = null;
    private Traversal<Vertex, Edge> edges = null;

    private Computer(Class<? extends GraphComputer> graphComputerClass) {
        this.graphComputerClass = graphComputerClass;
    }

    private Computer() {
    }

    public static Computer compute() {
        return new Computer(GraphComputer.class);
    }

    public static Computer compute(Class<? extends GraphComputer> graphComputerClass) {
        return new Computer(graphComputerClass);
    }

    public Computer graphComputer(Class<? extends GraphComputer> graphComputerClass) {
        Computer clone2 = this.clone();
        clone2.graphComputerClass = graphComputerClass;
        return clone2;
    }

    public Computer configure(String key, Object value2) {
        Computer clone2 = this.clone();
        clone2.configuration.put(key, value2);
        return clone2;
    }

    public Computer configure(Map<String, Object> configurations) {
        Computer clone2 = this.clone();
        clone2.configuration.putAll(configurations);
        return clone2;
    }

    public Computer workers(int workers) {
        Computer clone2 = this.clone();
        clone2.workers = workers;
        return clone2;
    }

    public Computer persist(GraphComputer.Persist persist) {
        Computer clone2 = this.clone();
        clone2.persist = persist;
        return clone2;
    }

    public Computer result(GraphComputer.ResultGraph resultGraph) {
        Computer clone2 = this.clone();
        clone2.resultGraph = resultGraph;
        return clone2;
    }

    public Computer vertices(Traversal<Vertex, Vertex> vertexFilter) {
        Computer clone2 = this.clone();
        clone2.vertices = vertexFilter;
        return clone2;
    }

    public Computer edges(Traversal<Vertex, Edge> edgeFilter) {
        Computer clone2 = this.clone();
        clone2.edges = edgeFilter;
        return clone2;
    }

    @Override
    public GraphComputer apply(Graph graph) {
        GraphComputer computer = this.graphComputerClass.equals(GraphComputer.class) ? graph.compute() : graph.compute(this.graphComputerClass);
        for (Map.Entry<String, Object> entry2 : this.configuration.entrySet()) {
            computer = computer.configure(entry2.getKey(), entry2.getValue());
        }
        if (-1 != this.workers) {
            computer = computer.workers(this.workers);
        }
        if (null != this.persist) {
            computer = computer.persist(this.persist);
        }
        if (null != this.resultGraph) {
            computer = computer.result(this.resultGraph);
        }
        if (null != this.vertices) {
            computer = computer.vertices(this.vertices);
        }
        if (null != this.edges) {
            computer.edges(this.edges);
        }
        return computer;
    }

    public String toString() {
        return this.graphComputerClass.getSimpleName().toLowerCase();
    }

    public Computer clone() {
        try {
            Computer clone2 = (Computer)super.clone();
            clone2.configuration = new HashMap<String, Object>(this.configuration);
            if (null != this.vertices) {
                clone2.vertices = this.vertices.asAdmin().clone();
            }
            if (null != this.edges) {
                clone2.edges = this.edges.asAdmin().clone();
            }
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Class<? extends GraphComputer> getGraphComputerClass() {
        return this.graphComputerClass;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public Traversal<Vertex, Vertex> getVertices() {
        return this.vertices;
    }

    public Traversal<Vertex, Edge> getEdges() {
        return this.edges;
    }

    public GraphComputer.Persist getPersist() {
        return this.persist;
    }

    public GraphComputer.ResultGraph getResultGraph() {
        return this.resultGraph;
    }

    public int getWorkers() {
        return this.workers;
    }
}

