/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.jsr223.AbstractGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.DefaultImportCustomizer;

public final class ImportGremlinPlugin
extends AbstractGremlinPlugin {
    private static final String NAME = "tinkerpop.import";

    private ImportGremlinPlugin(Builder builder) {
        super(NAME, builder.appliesTo, DefaultImportCustomizer.build().addClassImports(builder.classImports).addEnumImports(builder.enumImports).addMethodImports(builder.methodImports).create());
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private static final Pattern METHOD_PATTERN = Pattern.compile("(.*)#(.*)\\((.*)\\)");
        private static final Pattern ENUM_PATTERN = Pattern.compile("(.*)#(.*)");
        private Set<Class> classImports = new HashSet<Class>();
        private Set<Method> methodImports = new HashSet<Method>();
        private Set<Enum> enumImports = new HashSet<Enum>();
        private final Set<String> appliesTo = new HashSet<String>();

        private Builder() {
        }

        public Builder appliesTo(Collection<String> scriptEngineName) {
            this.appliesTo.addAll(scriptEngineName);
            return this;
        }

        public Builder classImports(Class<?> ... classes2) {
            this.classImports.addAll(Arrays.asList(classes2));
            return this;
        }

        public Builder classImports(Collection<String> classes2) {
            for (String clazz2 : classes2) {
                try {
                    this.classImports.add(Class.forName(clazz2));
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return this;
        }

        public Builder methodImports(Collection<String> methods2) {
            for (String method : methods2) {
                try {
                    if (method.endsWith("#*")) {
                        String classString = method.substring(0, method.length() - 2);
                        Class<?> clazz2 = Class.forName(classString);
                        this.methodImports.addAll(Builder.allStaticMethods(clazz2));
                        continue;
                    }
                    Matcher matcher2 = METHOD_PATTERN.matcher(method);
                    if (!matcher2.matches()) {
                        throw new IllegalArgumentException(String.format("Could not read method descriptor - check format of: %s", method));
                    }
                    String classString = matcher2.group(1);
                    String methodString = matcher2.group(2);
                    String argString = matcher2.group(3);
                    Class<?> clazz3 = Class.forName(classString);
                    this.methodImports.add(clazz3.getMethod(methodString, Builder.parse(argString)));
                }
                catch (IllegalArgumentException iae) {
                    throw iae;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return this;
        }

        public Builder methodImports(Method ... methods2) {
            this.methodImports.addAll(Arrays.asList(methods2));
            return this;
        }

        public Builder enumImports(Collection<String> enums) {
            for (String enumItem : enums) {
                try {
                    if (enumItem.endsWith("#*")) {
                        String classString = enumItem.substring(0, enumItem.length() - 2);
                        Class<?> clazz2 = Class.forName(classString);
                        this.enumImports.addAll(Builder.allEnums(clazz2));
                        continue;
                    }
                    Matcher matcher2 = ENUM_PATTERN.matcher(enumItem);
                    if (!matcher2.matches()) {
                        throw new IllegalArgumentException(String.format("Could not read enum descriptor - check format of: %s", enumItem));
                    }
                    String classString = matcher2.group(1);
                    String enumValString = matcher2.group(2);
                    Class<?> clazz3 = Class.forName(classString);
                    Stream.of(clazz3.getEnumConstants()).filter(e -> ((Enum)e).name().equals(enumValString)).findFirst().ifPresent(e -> this.enumImports.add((Enum)e));
                }
                catch (IllegalArgumentException iae) {
                    throw iae;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return this;
        }

        public Builder enumImports(Enum ... enums) {
            this.enumImports.addAll(Arrays.asList(enums));
            return this;
        }

        public ImportGremlinPlugin create() {
            if (this.enumImports.isEmpty() && this.classImports.isEmpty() && this.methodImports.isEmpty()) {
                throw new IllegalStateException("At least one import must be specified");
            }
            return new ImportGremlinPlugin(this);
        }

        private static List<Enum> allEnums(Class<?> clazz2) {
            return Stream.of(clazz2.getEnumConstants()).map(e -> (Enum)e).collect(Collectors.toList());
        }

        private static List<Method> allStaticMethods(Class<?> clazz2) {
            return Stream.of(clazz2.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).collect(Collectors.toList());
        }

        private static Class<?>[] parse(String argString) {
            if (null == argString || argString.isEmpty()) {
                return new Class[0];
            }
            List args2 = Stream.of(argString.split(",")).map(String::trim).collect(Collectors.toList());
            Class[] classes2 = new Class[args2.size()];
            for (int ix = 0; ix < args2.size(); ++ix) {
                try {
                    classes2[ix] = Class.forName((String)args2.get(ix));
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return classes2;
        }
    }
}

