/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;

public class GremlinScriptContext
implements ScriptContext {
    private Writer writer;
    private Writer errorWriter;
    private Reader reader;
    private Bindings engineScope = new SimpleBindings();
    private Bindings globalScope = null;
    private static List<Integer> scopes = new ArrayList<Integer>(2);

    public GremlinScriptContext(Reader in, Writer out, Writer error2) {
        this.reader = in;
        this.writer = out;
        this.errorWriter = error2;
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        switch (scope) {
            case 100: {
                if (null == bindings) {
                    throw new NullPointerException("Engine scope cannot be null.");
                }
                this.engineScope = bindings;
                break;
            }
            case 200: {
                this.globalScope = bindings;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope value.");
            }
        }
    }

    @Override
    public Object getAttribute(String name2) {
        this.checkName(name2);
        if (this.engineScope.containsKey(name2)) {
            return this.getAttribute(name2, 100);
        }
        if (this.globalScope != null && this.globalScope.containsKey(name2)) {
            return this.getAttribute(name2, 200);
        }
        return null;
    }

    @Override
    public Object getAttribute(String name2, int scope) {
        this.checkName(name2);
        switch (scope) {
            case 100: {
                return this.engineScope.get(name2);
            }
            case 200: {
                return this.globalScope != null ? this.globalScope.get(name2) : null;
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public Object removeAttribute(String name2, int scope) {
        this.checkName(name2);
        switch (scope) {
            case 100: {
                return this.getBindings(100) != null ? this.getBindings(100).remove(name2) : null;
            }
            case 200: {
                return this.getBindings(200) != null ? this.getBindings(200).remove(name2) : null;
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public void setAttribute(String name2, Object value2, int scope) {
        this.checkName(name2);
        switch (scope) {
            case 100: {
                this.engineScope.put(name2, value2);
                return;
            }
            case 200: {
                if (this.globalScope != null) {
                    this.globalScope.put(name2, value2);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public int getAttributesScope(String name2) {
        this.checkName(name2);
        if (this.engineScope.containsKey(name2)) {
            return 100;
        }
        if (this.globalScope != null && this.globalScope.containsKey(name2)) {
            return 200;
        }
        return -1;
    }

    @Override
    public Bindings getBindings(int scope) {
        if (scope == 100) {
            return this.engineScope;
        }
        if (scope == 200) {
            return this.globalScope;
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public List<Integer> getScopes() {
        return scopes;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    private void checkName(String name2) {
        Objects.requireNonNull(name2);
        if (name2.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
    }

    static {
        scopes.add(100);
        scopes.add(200);
        scopes = Collections.unmodifiableList(scopes);
    }
}

