/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.jsr223.ImportCustomizer;

public class DefaultImportCustomizer
implements ImportCustomizer {
    private final Set<Class> classImports;
    private final Set<Method> methodImports;
    private final Set<Enum> enumImports;
    private final Set<Field> fieldImports;

    private DefaultImportCustomizer(Builder builder) {
        this.classImports = builder.classImports;
        this.methodImports = builder.methodImports;
        this.enumImports = builder.enumImports;
        this.fieldImports = builder.fieldImports;
    }

    @Override
    public Set<Class> getClassImports() {
        return Collections.unmodifiableSet(this.classImports);
    }

    @Override
    public Set<Method> getMethodImports() {
        return Collections.unmodifiableSet(this.methodImports);
    }

    @Override
    public Set<Enum> getEnumImports() {
        return Collections.unmodifiableSet(this.enumImports);
    }

    @Override
    public Set<Field> getFieldImports() {
        return Collections.unmodifiableSet(this.fieldImports);
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder {
        private Set<Class> classImports = new LinkedHashSet<Class>();
        private Set<Method> methodImports = new LinkedHashSet<Method>();
        private Set<Enum> enumImports = new LinkedHashSet<Enum>();
        private Set<Field> fieldImports = new LinkedHashSet<Field>();

        private Builder() {
        }

        public Builder addClassImports(Class ... clazz2) {
            this.classImports.addAll(Arrays.asList(clazz2));
            return this;
        }

        public Builder addClassImports(Collection<Class> classes2) {
            this.classImports.addAll(classes2);
            return this;
        }

        public Builder addMethodImports(Method ... method) {
            this.methodImports.addAll(Arrays.asList(method));
            return this;
        }

        public Builder addMethodImports(Collection<Method> methods2) {
            this.methodImports.addAll(methods2);
            return this;
        }

        public Builder addFieldImports(Field ... field2) {
            this.fieldImports.addAll(Arrays.asList(field2));
            return this;
        }

        public Builder addFieldImports(Collection<Field> fields) {
            this.fieldImports.addAll(fields);
            return this;
        }

        public Builder addEnumImports(Enum ... e) {
            this.enumImports.addAll(Arrays.asList(e));
            return this;
        }

        public Builder addEnumImports(Collection<Enum> enums) {
            this.enumImports.addAll(enums);
            return this;
        }

        public DefaultImportCustomizer create() {
            return new DefaultImportCustomizer(this);
        }
    }
}

