/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.jsr223.BindingsCustomizer;
import org.apache.tinkerpop.gremlin.jsr223.ConcurrentBindings;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;
import org.apache.tinkerpop.gremlin.jsr223.GremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineFactory;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.ScriptCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGremlinScriptEngineManager
implements GremlinScriptEngineManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultGremlinScriptEngineManager.class);
    private final HashSet<GremlinScriptEngineFactory> engineSpis = new HashSet();
    private final HashMap<String, GremlinScriptEngineFactory> nameAssociations = new HashMap();
    private final HashMap<String, GremlinScriptEngineFactory> extensionAssociations = new HashMap();
    private final HashMap<String, GremlinScriptEngineFactory> mimeTypeAssociations = new HashMap();
    private Bindings globalScope = new ConcurrentBindings();
    private List<GremlinPlugin> plugins = new ArrayList<GremlinPlugin>();

    public DefaultGremlinScriptEngineManager() {
        ClassLoader ctxtLoader = Thread.currentThread().getContextClassLoader();
        this.initEngines(ctxtLoader);
    }

    public DefaultGremlinScriptEngineManager(ClassLoader loader) {
        this.initEngines(loader);
    }

    @Override
    public List<Customizer> getCustomizers(String scriptEngineName) {
        List<Customizer> pluginCustomizers = this.plugins.stream().flatMap(plugin -> {
            Optional<Customizer[]> customizers = plugin.getCustomizers(scriptEngineName);
            return Stream.of((Object[])customizers.orElse(new Customizer[0]));
        }).collect(Collectors.toList());
        return pluginCustomizers;
    }

    @Override
    public void addPlugin(GremlinPlugin plugin) {
        if (plugin != null) {
            this.plugins.add(plugin);
        }
    }

    @Override
    public synchronized void setBindings(Bindings bindings) {
        if (null == bindings) {
            throw new IllegalArgumentException("Global scope cannot be null.");
        }
        this.globalScope = bindings;
    }

    @Override
    public Bindings getBindings() {
        return this.globalScope;
    }

    @Override
    public void put(String key, Object value2) {
        if (null == key) {
            throw new IllegalArgumentException("key may not be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key may not be empty");
        }
        this.globalScope.put(key, value2);
    }

    @Override
    public Object get(String key) {
        return this.globalScope.get(key);
    }

    @Override
    public GremlinScriptEngine getEngineByName(String shortName) {
        if (null == shortName) {
            throw new NullPointerException();
        }
        GremlinScriptEngineFactory obj = this.nameAssociations.get(shortName);
        if (null != obj) {
            GremlinScriptEngineFactory spi = obj;
            try {
                return this.createGremlinScriptEngine(spi);
            }
            catch (Exception exp) {
                logger.error(String.format("Could not create GremlinScriptEngine for %s", shortName), exp);
            }
        }
        for (GremlinScriptEngineFactory spi : this.engineSpis) {
            List<String> names = null;
            try {
                names = spi.getNames();
            }
            catch (Exception exp) {
                logger.error("Could not get GremlinScriptEngine names", exp);
            }
            if (names == null) continue;
            for (String name2 : names) {
                if (!shortName.equals(name2)) continue;
                try {
                    return this.createGremlinScriptEngine(spi);
                }
                catch (Exception exp) {
                    logger.error(String.format("Could not create GremlinScriptEngine for %s", shortName), exp);
                }
            }
        }
        return null;
    }

    @Override
    public GremlinScriptEngine getEngineByExtension(String extension2) {
        if (null == extension2) {
            throw new NullPointerException();
        }
        GremlinScriptEngineFactory obj = this.extensionAssociations.get(extension2);
        if (null != obj) {
            GremlinScriptEngineFactory spi = obj;
            try {
                return this.createGremlinScriptEngine(spi);
            }
            catch (Exception exp) {
                logger.error(String.format("Could not create GremlinScriptEngine for %s", extension2), exp);
            }
        }
        for (GremlinScriptEngineFactory spi : this.engineSpis) {
            List<String> exts = null;
            try {
                exts = spi.getExtensions();
            }
            catch (Exception exp) {
                logger.error("Could not get GremlinScriptEngine extensions", exp);
            }
            if (exts == null) continue;
            for (String ext : exts) {
                if (!extension2.equals(ext)) continue;
                try {
                    return this.createGremlinScriptEngine(spi);
                }
                catch (Exception exp) {
                    logger.error(String.format("Could not create GremlinScriptEngine for %s", extension2), exp);
                }
            }
        }
        return null;
    }

    @Override
    public GremlinScriptEngine getEngineByMimeType(String mimeType) {
        if (null == mimeType) {
            throw new NullPointerException();
        }
        GremlinScriptEngineFactory obj = this.mimeTypeAssociations.get(mimeType);
        if (null != obj) {
            GremlinScriptEngineFactory spi = obj;
            try {
                return this.createGremlinScriptEngine(spi);
            }
            catch (Exception exp) {
                logger.error(String.format("Could not create GremlinScriptEngine for %s", mimeType), exp);
            }
        }
        for (GremlinScriptEngineFactory spi : this.engineSpis) {
            List<String> types2 = null;
            try {
                types2 = spi.getMimeTypes();
            }
            catch (Exception exp) {
                logger.error("Could not get GremlinScriptEngine mimetypes", exp);
            }
            if (types2 == null) continue;
            for (String type : types2) {
                if (!mimeType.equals(type)) continue;
                try {
                    return this.createGremlinScriptEngine(spi);
                }
                catch (Exception exp) {
                    logger.error(String.format("Could not create GremlinScriptEngine for %s", mimeType), exp);
                }
            }
        }
        return null;
    }

    @Override
    public List<GremlinScriptEngineFactory> getEngineFactories() {
        ArrayList res = new ArrayList(this.engineSpis.size());
        res.addAll(this.engineSpis.stream().collect(Collectors.toList()));
        return Collections.unmodifiableList(res);
    }

    @Override
    public void registerEngineName(String name2, GremlinScriptEngineFactory factory) {
        if (null == name2 || null == factory) {
            throw new NullPointerException();
        }
        this.nameAssociations.put(name2, factory);
    }

    @Override
    public void registerEngineMimeType(String type, GremlinScriptEngineFactory factory) {
        if (null == type || null == factory) {
            throw new NullPointerException();
        }
        this.mimeTypeAssociations.put(type, factory);
    }

    @Override
    public void registerEngineExtension(String extension2, GremlinScriptEngineFactory factory) {
        if (null == extension2 || null == factory) {
            throw new NullPointerException();
        }
        this.extensionAssociations.put(extension2, factory);
    }

    private ServiceLoader<GremlinScriptEngineFactory> getServiceLoader(ClassLoader loader) {
        if (loader != null) {
            return ServiceLoader.load(GremlinScriptEngineFactory.class, loader);
        }
        return ServiceLoader.loadInstalled(GremlinScriptEngineFactory.class);
    }

    private void initEngines(ClassLoader loader) {
        Iterator itty;
        try {
            ServiceLoader sl = AccessController.doPrivileged(() -> this.getServiceLoader(loader));
            itty = sl.iterator();
        }
        catch (ServiceConfigurationError err2) {
            logger.error("Can't find GremlinScriptEngineFactory providers: " + err2.getMessage(), err2);
            return;
        }
        try {
            while (itty.hasNext()) {
                try {
                    GremlinScriptEngineFactory factory = (GremlinScriptEngineFactory)itty.next();
                    factory.setCustomizerManager(this);
                    this.engineSpis.add(factory);
                }
                catch (ServiceConfigurationError err3) {
                    logger.error("GremlinScriptEngineManager providers.next(): " + err3.getMessage(), err3);
                }
            }
        }
        catch (ServiceConfigurationError err4) {
            logger.error("GremlinScriptEngineManager providers.hasNext(): " + err4.getMessage(), err4);
        }
    }

    private GremlinScriptEngine createGremlinScriptEngine(GremlinScriptEngineFactory spi) {
        GremlinScriptEngine engine = spi.getScriptEngine();
        this.getCustomizers(spi.getEngineName()).stream().filter(p -> p instanceof BindingsCustomizer).map(p -> (BindingsCustomizer)p).filter(bc -> bc.getScope() == 200).flatMap(bc -> bc.getBindings().entrySet().stream()).forEach(kv -> {
            if (this.globalScope.containsKey(kv.getKey())) {
                logger.warn("Overriding the global binding [{}] - was [{}] and is now [{}]", kv.getKey(), this.globalScope.get(kv.getKey()), kv.getValue());
            }
            this.globalScope.put((String)kv.getKey(), kv.getValue());
        });
        engine.setBindings(this.getBindings(), 200);
        this.getCustomizers(spi.getEngineName()).stream().filter(p -> p instanceof BindingsCustomizer).map(p -> (BindingsCustomizer)p).filter(bc -> bc.getScope() == 100).forEach(bc -> engine.getBindings(100).putAll(bc.getBindings()));
        List scriptCustomizers = this.getCustomizers(spi.getEngineName()).stream().filter(p -> p instanceof ScriptCustomizer).map(p -> (ScriptCustomizer)p).collect(Collectors.toList());
        scriptCustomizers.stream().flatMap(sc -> sc.getScripts().stream()).map(l -> String.join((CharSequence)System.lineSeparator(), l)).forEach(initScript -> {
            try {
                Object initializedBindings = engine.eval((String)initScript);
                if (initializedBindings != null && initializedBindings instanceof Map) {
                    ((Map)initializedBindings).forEach((k, v) -> this.put((String)k, v));
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        });
        return engine;
    }
}

