/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.tinkerpop.gremlin.jsr223.DefaultGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;

public class CachedGremlinScriptEngineManager
extends DefaultGremlinScriptEngineManager {
    private final ConcurrentHashMap<String, GremlinScriptEngine> cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> extensionToName = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> mimeToName = new ConcurrentHashMap();

    public CachedGremlinScriptEngineManager() {
    }

    public CachedGremlinScriptEngineManager(ClassLoader loader) {
        super(loader);
    }

    @Override
    public GremlinScriptEngine getEngineByName(String shortName) {
        GremlinScriptEngine engine = this.cache.computeIfAbsent(shortName, x$0 -> super.getEngineByName((String)x$0));
        this.registerLookUpInfo(engine, shortName);
        return engine;
    }

    @Override
    public GremlinScriptEngine getEngineByExtension(String extension2) {
        if (!this.extensionToName.containsKey(extension2)) {
            GremlinScriptEngine engine = super.getEngineByExtension(extension2);
            this.registerLookUpInfo(engine, engine.getFactory().getEngineName());
            return engine;
        }
        return this.cache.get(this.extensionToName.get(extension2));
    }

    @Override
    public GremlinScriptEngine getEngineByMimeType(String mimeType) {
        if (!this.mimeToName.containsKey(mimeType)) {
            GremlinScriptEngine engine = super.getEngineByMimeType(mimeType);
            this.registerLookUpInfo(engine, engine.getFactory().getEngineName());
            return engine;
        }
        return this.cache.get(this.mimeToName.get(mimeType));
    }

    private void registerLookUpInfo(GremlinScriptEngine engine, String shortName) {
        if (null == engine) {
            throw new IllegalArgumentException(String.format("%s is not an available GremlinScriptEngine", shortName));
        }
        this.cache.putIfAbsent(shortName, engine);
        engine.getFactory().getExtensions().forEach(ext -> this.extensionToName.putIfAbsent((String)ext, shortName));
        engine.getFactory().getMimeTypes().forEach(mime -> this.mimeToName.putIfAbsent((String)mime, shortName));
    }
}

