/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseResult;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatus;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.NettyBufferFactory;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;

public class ResponseMessageSerializer {
    private static final NettyBufferFactory bufferFactory = new NettyBufferFactory();

    public ResponseMessage readValue(ByteBuf byteBuf, GraphBinaryReader context) throws SerializationException {
        Buffer buffer = bufferFactory.create(byteBuf);
        int version = buffer.readByte() & 0xFF;
        if (version >>> 7 != 1) {
            throw new SerializationException("The most significant bit should be set according to the format");
        }
        try {
            return ResponseMessage.build(context.readValue(buffer, UUID.class, true)).code(ResponseStatusCode.getFromValue(context.readValue(buffer, Integer.class, false))).statusMessage(context.readValue(buffer, String.class, true)).statusAttributes(context.readValue(buffer, Map.class, false)).responseMetaData(context.readValue(buffer, Map.class, false)).result(context.read(buffer)).create();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeValue(ResponseMessage value2, ByteBuf byteBuf, GraphBinaryWriter context) throws SerializationException {
        Buffer buffer = bufferFactory.create(byteBuf);
        ResponseResult result2 = value2.getResult();
        ResponseStatus status = value2.getStatus();
        try {
            buffer.writeByte(-127);
            context.writeValue(value2.getRequestId(), buffer, true);
            context.writeValue(status.getCode().getValue(), buffer, false);
            context.writeValue(status.getMessage(), buffer, true);
            context.writeValue(status.getAttributes(), buffer, false);
            context.writeValue(result2.getMeta(), buffer, false);
            context.write(result2.getData(), buffer);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }
}

