/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;

public class ResponseMessageGryoSerializer
implements SerializerShim<ResponseMessage> {
    @Override
    public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, ResponseMessage responseMessage) {
        kryo.writeObjectOrNull(output, responseMessage.getRequestId() != null ? responseMessage.getRequestId() : null, UUID.class);
        output.writeShort((short)responseMessage.getStatus().getCode().getValue());
        output.writeString(responseMessage.getStatus().getMessage());
        kryo.writeClassAndObject(output, responseMessage.getStatus().getAttributes());
        kryo.writeClassAndObject(output, responseMessage.getResult().getData());
        kryo.writeClassAndObject(output, responseMessage.getResult().getMeta());
    }

    @Override
    public <I extends InputShim> ResponseMessage read(KryoShim<I, ?> kryo, I input2, Class<ResponseMessage> clazz2) {
        UUID requestId = kryo.readObjectOrNull(input2, UUID.class);
        short status = input2.readShort();
        String statusMsg = input2.readString();
        Map statusAttributes = (Map)kryo.readClassAndObject(input2);
        Object result2 = kryo.readClassAndObject(input2);
        Map metaAttributes = (Map)kryo.readClassAndObject(input2);
        return ResponseMessage.build(requestId).code(ResponseStatusCode.getFromValue(status)).statusMessage(statusMsg).statusAttributes(statusAttributes).result(result2).responseMetaData(metaAttributes).create();
    }
}

