/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.driver.ser.NettyBuffer;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.BufferFactory;

public class NettyBufferFactory
implements BufferFactory<ByteBuf> {
    @Override
    public Buffer create(ByteBuf value2) {
        return new NettyBuffer(value2);
    }

    @Override
    public Buffer wrap(ByteBuffer value2) {
        return this.create(Unpooled.wrappedBuffer(value2));
    }

    private static ByteBuf getFromIndex(Buffer buffer, int index2) {
        if (buffer.nioBufferCount() == 1) {
            return Unpooled.wrappedBuffer(buffer.nioBuffer(index2, buffer.capacity() - index2));
        }
        return Unpooled.wrappedBuffer(buffer.nioBuffers(index2, buffer.capacity() - index2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readRaw(Buffer buffer, Consumer<ByteBuf> consumer) {
        if (buffer instanceof NettyBuffer) {
            consumer.accept(((NettyBuffer)buffer).getUnderlyingBuffer());
            return;
        }
        int initialIndex = buffer.readerIndex();
        ByteBuf newBuffer = NettyBufferFactory.getFromIndex(buffer, initialIndex);
        try {
            consumer.accept(newBuffer);
            buffer.readerIndex(initialIndex + newBuffer.readerIndex());
        }
        finally {
            newBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRaw(Buffer buffer, Consumer<ByteBuf> consumer) {
        if (buffer instanceof NettyBuffer) {
            consumer.accept(((NettyBuffer)buffer).getUnderlyingBuffer());
            return;
        }
        int initialIndex = buffer.writerIndex();
        ByteBuf newBuffer = NettyBufferFactory.getFromIndex(buffer, initialIndex);
        newBuffer.writerIndex(0);
        try {
            consumer.accept(newBuffer);
            buffer.writerIndex(initialIndex + newBuffer.writerIndex());
        }
        finally {
            newBuffer.release();
        }
    }
}

