/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;

final class NettyBuffer
implements Buffer {
    private final ByteBuf buffer;

    NettyBuffer(ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer can't be null");
        }
        this.buffer = buffer;
    }

    @Override
    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public Buffer readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
        return this;
    }

    @Override
    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public Buffer writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
        return this;
    }

    @Override
    public Buffer markWriterIndex() {
        this.buffer.markWriterIndex();
        return this;
    }

    @Override
    public Buffer resetWriterIndex() {
        this.buffer.resetWriterIndex();
        return this;
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.buffer.readByte();
    }

    @Override
    public short readShort() {
        return this.buffer.readShort();
    }

    @Override
    public int readInt() {
        return this.buffer.readInt();
    }

    @Override
    public long readLong() {
        return this.buffer.readLong();
    }

    @Override
    public float readFloat() {
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.readDouble();
    }

    @Override
    public Buffer readBytes(byte[] destination) {
        this.buffer.readBytes(destination);
        return this;
    }

    @Override
    public Buffer readBytes(byte[] destination, int dstIndex, int length) {
        this.buffer.readBytes(destination, dstIndex, length);
        return this;
    }

    @Override
    public Buffer readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
        return this;
    }

    @Override
    public Buffer readBytes(OutputStream out, int length) throws IOException {
        this.buffer.readBytes(out, length);
        return this;
    }

    @Override
    public Buffer writeBoolean(boolean value2) {
        this.buffer.writeBoolean(value2);
        return this;
    }

    @Override
    public Buffer writeByte(int value2) {
        this.buffer.writeByte(value2);
        return this;
    }

    @Override
    public Buffer writeShort(int value2) {
        this.buffer.writeShort(value2);
        return this;
    }

    @Override
    public Buffer writeInt(int value2) {
        this.buffer.writeInt(value2);
        return this;
    }

    @Override
    public Buffer writeLong(long value2) {
        this.buffer.writeLong(value2);
        return this;
    }

    @Override
    public Buffer writeFloat(float value2) {
        this.buffer.writeFloat(value2);
        return this;
    }

    @Override
    public Buffer writeDouble(double value2) {
        this.buffer.writeDouble(value2);
        return this;
    }

    @Override
    public Buffer writeBytes(byte[] src) {
        this.buffer.writeBytes(src);
        return this;
    }

    @Override
    public Buffer writeBytes(ByteBuffer src) {
        this.buffer.writeBytes(src);
        return this;
    }

    @Override
    public Buffer writeBytes(byte[] src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
        return this;
    }

    @Override
    public boolean release() {
        return this.buffer.release();
    }

    @Override
    public Buffer retain() {
        this.buffer.retain();
        return this;
    }

    @Override
    public int referenceCount() {
        return this.buffer.refCnt();
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return this.buffer.nioBuffers();
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.buffer.nioBuffer();
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        return this.buffer.nioBuffer(index2, length);
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        return this.buffer.nioBuffers(index2, length);
    }

    @Override
    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    @Override
    public Buffer getBytes(int index2, byte[] dst) {
        this.buffer.getBytes(index2, dst);
        return this;
    }

    public ByteBuf getUnderlyingBuffer() {
        return this.buffer;
    }
}

